/*
 * Decompiled with CFR 0.152.
 */
package com.davidmoten.rtree;

import com.davidmoten.guavamini.Preconditions;
import com.davidmoten.rtree.Node;
import com.davidmoten.rtree.geometry.Geometry;

final class NodePosition<T, S extends Geometry> {
    private Node<T, S> node;
    private int position;

    NodePosition(Node<T, S> node, int position) {
        Preconditions.checkNotNull(node);
        this.node = node;
        this.position = position;
    }

    Node<T, S> node() {
        return this.node;
    }

    int position() {
        return this.position;
    }

    boolean hasRemaining() {
        return this.position != this.node.count();
    }

    void setPosition(int position) {
        this.position = position;
    }

    public String toString() {
        String builder = "NodePosition [node=" + this.node + ", position=" + this.position + "]";
        return builder;
    }
}

