/*
 * Decompiled with CFR 0.152.
 */
package com.davidmoten.rtree.geometry.internal;

import com.davidmoten.rtree.geometry.Geometry;
import com.davidmoten.rtree.geometry.Point;
import com.davidmoten.rtree.geometry.Rectangle;
import com.davidmoten.rtree.geometry.internal.GeometryUtil;
import java.util.Arrays;

public final class PointDouble
implements Point {
    private final double[] x;

    private PointDouble(double[] x) {
        this.x = x;
    }

    public static PointDouble create(double[] x) {
        return new PointDouble(x);
    }

    @Override
    public Rectangle mbr() {
        return this;
    }

    @Override
    public double distance(Rectangle r) {
        return GeometryUtil.distance(this.x, r);
    }

    @Override
    public boolean intersects(Rectangle r) {
        return GeometryUtil.intersects(this.x, this.x, r.mins(), r.maxes());
    }

    @Override
    public double[] mins() {
        return this.x;
    }

    public String toString() {
        return "Point " + Arrays.toString(this.mins());
    }

    @Override
    public Geometry geometry() {
        return this;
    }

    @Override
    public double volume() {
        return 0.0;
    }

    @Override
    public Rectangle add(Rectangle r) {
        return Rectangle.create(GeometryUtil.min(this.x, r.mins()), GeometryUtil.max(this.x, r.maxes()));
    }

    @Override
    public boolean contains(double ... p) {
        return Arrays.equals(this.x, p);
    }

    @Override
    public double intersectionVolume(Rectangle r) {
        return 0.0;
    }

    @Override
    public double surfaceArea() {
        return 0.0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.x);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return Arrays.equals(this.x, ((PointDouble)obj).x);
    }

    @Override
    public int dimensions() {
        return this.x.length;
    }
}

