/*
 * Decompiled with CFR 0.152.
 */
package com.davidmoten.rtree.internal;

import com.davidmoten.guavamini.Objects;
import com.davidmoten.guavamini.Preconditions;
import com.davidmoten.rtree.Entry;
import com.davidmoten.rtree.geometry.Geometry;
import com.davidmoten.rtree.internal.util.ObjectsHelper;

public final class EntryDefault<T, S extends Geometry>
implements Entry<T, S> {
    private final T value;
    private final S geometry;

    public EntryDefault(T value, S geometry) {
        Preconditions.checkNotNull(geometry);
        this.value = value;
        this.geometry = geometry;
    }

    public static <T, S extends Geometry> Entry<T, S> entry(T value, S geometry) {
        return new EntryDefault<T, S>(value, geometry);
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public S geometry() {
        return this.geometry;
    }

    public String toString() {
        String builder = "Entry [value=" + this.value + ", geometry=" + this.geometry + "]";
        return builder;
    }

    public int hashCode() {
        return Objects.hashCode(this.value, this.geometry);
    }

    public boolean equals(Object obj) {
        EntryDefault other = ObjectsHelper.asClass(obj, EntryDefault.class);
        if (other != null) {
            return Objects.equal(this.value, other.value) && Objects.equal(this.geometry, other.geometry);
        }
        return false;
    }
}

