/*
 * Decompiled with CFR 0.152.
 */
package com.davidmoten.rtree.internal;

import com.davidmoten.rtree.Context;
import com.davidmoten.rtree.Entry;
import com.davidmoten.rtree.Leaf;
import com.davidmoten.rtree.Node;
import com.davidmoten.rtree.geometry.Geometry;
import com.davidmoten.rtree.geometry.ListPair;
import com.davidmoten.rtree.internal.NodeAndEntries;
import com.davidmoten.rtree.internal.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class LeafHelper {
    private LeafHelper() {
    }

    public static <T, S extends Geometry> NodeAndEntries<T, S> delete(Entry<? extends T, ? extends S> entry, boolean all, Leaf<T, S> leaf) {
        List<Entry<T, S>> entries = leaf.entries();
        if (!entries.contains(entry)) {
            return new NodeAndEntries<T, S>(Optional.of(leaf), Collections.emptyList(), 0);
        }
        ArrayList<Entry<T, S>> entries2 = new ArrayList<Entry<T, S>>(entries);
        entries2.remove(entry);
        int numDeleted = 1;
        while (all && entries2.remove(entry)) {
            ++numDeleted;
        }
        if (entries2.size() >= leaf.context().minChildren()) {
            Leaf<T, S> node = leaf.context().factory().createLeaf(entries2, leaf.context());
            return new NodeAndEntries<T, S>(Optional.of(node), Collections.emptyList(), numDeleted);
        }
        return new NodeAndEntries<T, S>(Optional.empty(), entries2, numDeleted);
    }

    public static <T, S extends Geometry> List<Node<T, S>> add(Entry<? extends T, ? extends S> entry, Leaf<T, S> leaf) {
        List<Entry<T, S>> entries = leaf.entries();
        Context context = leaf.context();
        List entries2 = Util.add(entries, entry);
        if (entries2.size() <= context.maxChildren()) {
            return Collections.singletonList(context.factory().createLeaf(entries2, context));
        }
        ListPair pair = context.splitter().split(entries2, context.minChildren());
        return LeafHelper.makeLeaves(pair, context);
    }

    private static <T, S extends Geometry> List<Node<T, S>> makeLeaves(ListPair<Entry<T, S>> pair, Context<T, S> context) {
        ArrayList<Node<T, S>> list = new ArrayList<Node<T, S>>(2);
        list.add(context.factory().createLeaf(pair.group1().list(), context));
        list.add(context.factory().createLeaf(pair.group2().list(), context));
        return list;
    }
}

