/*
 * Decompiled with CFR 0.152.
 */
package com.davidmoten.rtree.internal;

import com.davidmoten.guavamini.Preconditions;
import com.davidmoten.rtree.Context;
import com.davidmoten.rtree.Entry;
import com.davidmoten.rtree.Node;
import com.davidmoten.rtree.NonLeaf;
import com.davidmoten.rtree.geometry.Geometry;
import com.davidmoten.rtree.geometry.Rectangle;
import com.davidmoten.rtree.internal.NodeAndEntries;
import com.davidmoten.rtree.internal.NonLeafHelper;
import com.davidmoten.rtree.internal.Util;
import java.util.List;

public final class NonLeafDefault<T, S extends Geometry>
implements NonLeaf<T, S> {
    private final List<? extends Node<T, S>> children;
    private final Rectangle mbr;
    private final Context<T, S> context;

    public NonLeafDefault(List<? extends Node<T, S>> children, Context<T, S> context) {
        Preconditions.checkArgument(!children.isEmpty());
        this.context = context;
        this.children = children;
        this.mbr = Util.mbr(children);
    }

    @Override
    public Geometry geometry() {
        return this.mbr;
    }

    @Override
    public int count() {
        return this.children.size();
    }

    @Override
    public List<Node<T, S>> add(Entry<? extends T, ? extends S> entry) {
        return NonLeafHelper.add(entry, this);
    }

    @Override
    public NodeAndEntries<T, S> delete(Entry<? extends T, ? extends S> entry, boolean all) {
        return NonLeafHelper.delete(entry, all, this);
    }

    @Override
    public Context<T, S> context() {
        return this.context;
    }

    @Override
    public Node<T, S> child(int i) {
        return this.children.get(i);
    }

    @Override
    public List<Node<T, S>> children() {
        return this.children;
    }

    public String toString() {
        return "NonLeafDefault [mbr=" + this.mbr + ", children=" + this.children + "]";
    }
}

