/*
 * Decompiled with CFR 0.152.
 */
package com.davidmoten.rtree.internal;

import com.davidmoten.rtree.Context;
import com.davidmoten.rtree.Entry;
import com.davidmoten.rtree.Node;
import com.davidmoten.rtree.NonLeaf;
import com.davidmoten.rtree.geometry.Geometry;
import com.davidmoten.rtree.geometry.ListPair;
import com.davidmoten.rtree.internal.NodeAndEntries;
import com.davidmoten.rtree.internal.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class NonLeafHelper {
    private NonLeafHelper() {
    }

    public static <T, S extends Geometry> List<Node<T, S>> add(Entry<? extends T, ? extends S> entry, NonLeaf<T, S> node) {
        List<Node<? extends T, ? extends S>> list;
        Node<T, S> child;
        Context context = node.context();
        List<Node<T, S>> children = node.children();
        List<Node<T, S>> children2 = Util.replace(children, child = context.selector().select(entry.geometry().mbr(), children), list = child.add(entry));
        if (children2.size() <= context.maxChildren()) {
            return Collections.singletonList(context.factory().createNonLeaf(children2, context));
        }
        ListPair<Node<? extends T, ? extends S>> pair = context.splitter().split(children2, context.minChildren());
        return NonLeafHelper.makeNonLeaves(pair, context);
    }

    private static <T, S extends Geometry> List<Node<T, S>> makeNonLeaves(ListPair<? extends Node<T, S>> pair, Context<T, S> context) {
        ArrayList<Node<T, S>> list = new ArrayList<Node<T, S>>();
        list.add(context.factory().createNonLeaf(pair.group1().list(), context));
        list.add(context.factory().createNonLeaf(pair.group2().list(), context));
        return list;
    }

    public static <T, S extends Geometry> NodeAndEntries<T, S> delete(Entry<? extends T, ? extends S> entry, boolean all, NonLeaf<T, S> node) {
        ArrayList addTheseEntries = new ArrayList();
        ArrayList<Node<T, S>> removeTheseNodes = new ArrayList<Node<T, S>>();
        ArrayList<Node<T, S>> addTheseNodes = new ArrayList<Node<T, S>>();
        int countDeleted = 0;
        List<Node<T, S>> children = node.children();
        for (Node<T, S> node2 : children) {
            if (!entry.geometry().intersects(node2.geometry().mbr())) continue;
            NodeAndEntries<T, S> result = node2.delete(entry, all);
            if (result.node().isPresent()) {
                if (result.node().get() == node2) continue;
                addTheseNodes.add(result.node().get());
                removeTheseNodes.add(node2);
                addTheseEntries.addAll(result.entriesToAdd());
                countDeleted += result.countDeleted();
                if (all) continue;
                break;
            }
            removeTheseNodes.add(node2);
            addTheseEntries.addAll(result.entriesToAdd());
            countDeleted += result.countDeleted();
            if (all) continue;
            break;
        }
        if (removeTheseNodes.isEmpty()) {
            return new NodeAndEntries<T, S>(Optional.of(node), Collections.emptyList(), 0);
        }
        List<Node<T, S>> nodes = Util.remove(children, removeTheseNodes);
        nodes.addAll(addTheseNodes);
        if (nodes.size() == 0) {
            return new NodeAndEntries(Optional.empty(), addTheseEntries, countDeleted);
        }
        NonLeaf<T, S> nonLeaf = node.context().factory().createNonLeaf(nodes, node.context());
        return new NodeAndEntries<T, S>(Optional.of(nonLeaf), addTheseEntries, countDeleted);
    }
}

