/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.radar.radioactive.client.model.ModArmPoses;
import com.radar.radioactive.client.overlay.GeigerOverlay;
import com.radar.radioactive.client.overlay.GeigerUIRegistry;
import com.radar.radioactive.client.overlay.VacuumTubeOverlay;
import com.radar.radioactive.client.particles.DecontaminationParticle;
import com.radar.radioactive.client.particles.RadFogParticle;
import com.radar.radioactive.client.renderer.DeathEffectRenderer;
import com.radar.radioactive.client.renderer.item.HangingBackCurioRenderer;
import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.registry.ModItems;
import com.radar.radioactive.common.registry.ModMenuTypes;
import java.io.IOException;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RadioactiveClient {
    private static ShaderInstance vacuumTubeShader;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            GeigerUIRegistry.registerAll();
            ModMenuTypes.registerMenuScreens();
            ModArmPoses.registerArmPoses();
            MinecraftForge.EVENT_BUS.register((Object)new DeathEffectRenderer());
            CuriosRendererRegistry.register((Item)((Item)ModItems.GEIGER_COUNTER.get()), HangingBackCurioRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ModItems.SHODDY_GEIGER_COUNTER.get()), HangingBackCurioRenderer::new);
            ItemProperties.register((Item)((Item)ModItems.SHODDY_GEIGER_COUNTER.get()), (ResourceLocation)new ResourceLocation("radioactive", "broken"), (stack, level, entity, seed) -> {
                if (entity == null) {
                    return 0.0f;
                }
                if (stack.m_41782_()) {
                    return stack.m_41783_().m_128471_("broken") ? 1.0f : 0.0f;
                }
                return 0.0f;
            });
            ItemProperties.register((Item)((Item)ModItems.SHODDY_GEIGER_COUNTER.get()), (ResourceLocation)new ResourceLocation("radioactive", "active"), (stack, level, entity, seed) -> {
                if (entity == null) {
                    return 0.0f;
                }
                if (stack.m_41782_()) {
                    return stack.m_41783_().m_128457_("last_reading") > 0.0f ? 1.0f : 0.0f;
                }
                return 0.0f;
            });
        });
        Radioactive.LOGGER.info("Radioactive client setup complete");
    }

    @SubscribeEvent
    public static void onRegisterShaders(RegisterShadersEvent event) {
        try {
            ResourceLocation shaderLocation = new ResourceLocation("radioactive", "vacuum_tube");
            event.registerShader(new ShaderInstance(event.getResourceProvider(), shaderLocation, DefaultVertexFormat.f_85819_), shader -> {
                vacuumTubeShader = shader;
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load custom vacuum tube shader", e);
        }
    }

    public static ShaderInstance getVacuumTubeShader() {
        return vacuumTubeShader;
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)Radioactive.DECONTAMINATION_PARTICLE.get(), DecontaminationParticle.Provider::new);
        event.registerSpriteSet((ParticleType)Radioactive.RAD_FOG.get(), RadFogParticle.DefaultFactory::new);
        Radioactive.LOGGER.info("Radioactive particles registered");
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("geiger_counter", GeigerOverlay.INSTANCE.HUD_GEIGER);
        event.registerAboveAll("vacuum_tube", VacuumTubeOverlay.INSTANCE.HUD_VACUUM_TUBE);
        Radioactive.LOGGER.info("Radioactive overlays registered");
    }
}

