/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.client.events;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.radar.radioactive.common.Radioactive;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class RadioactiveFogHandler {
    private static final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private static final int UPDATE_FREQUENCY = 3;
    private static final long DAY_LENGTH = 24000L;
    private static final long NIGHT_START = 13000L;
    private static final long NIGHT_END = 23000L;
    private static boolean isFogActive = false;
    private static final int updateCounter = 0;
    private static float maxHeightAbovePlayer = 1.0f;
    private static float maxHeightAboveGround = 1.0f;
    private static float minHeightAboveGround = 0.5f;
    private static boolean enforceHeightLimit = false;
    private static float predictiveFactor = 2.0f;
    private static float minDistance = 30.0f;
    private static float maxDistance = 100.0f;
    private static final float movementMemory = 0.8f;
    private static double prevX = 0.0;
    private static double prevZ = 0.0;
    private static double movingDirX = 0.0;
    private static double movingDirZ = 0.0;

    @SubscribeEvent
    public static void onComputeFogColor(ViewportEvent.ComputeFogColor event) {
        ClientLevel level;
        if (RadioactiveFogHandler.isRadioactiveFogActive(event.getCamera()) && (level = Minecraft.m_91087_().f_91073_) != null) {
            long timeOfDay = level.m_46468_() % 24000L;
            float oldR = event.getRed();
            float oldG = event.getGreen();
            float oldB = event.getBlue();
            float blendFactor = 0.5f;
            if (timeOfDay > 13000L && timeOfDay < 23000L) {
                event.setRed(Mth.m_14179_((float)blendFactor, (float)oldR, (float)0.1f));
                event.setGreen(Mth.m_14179_((float)blendFactor, (float)oldG, (float)0.5f));
                event.setBlue(Mth.m_14179_((float)blendFactor, (float)oldB, (float)0.3f));
            } else {
                event.setRed(Mth.m_14179_((float)blendFactor, (float)oldR, (float)0.2f));
                event.setGreen(Mth.m_14179_((float)blendFactor, (float)oldG, (float)0.8f));
                event.setBlue(Mth.m_14179_((float)blendFactor, (float)oldB, (float)0.2f));
            }
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY && RadioactiveFogHandler.isRadioactiveFogActive(Minecraft.m_91087_().f_91063_.m_109153_())) {
            PoseStack poseStack = event.getPoseStack();
            Matrix4f projectionMatrix = event.getProjectionMatrix();
            float partialTick = event.getPartialTick();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::m_172811_);
            float r = 0.1f;
            float g = 0.3f;
            float b = 0.1f;
            float a = 0.7f;
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            bufferbuilder.m_252986_(matrix, -100.0f, -100.0f, -100.0f).m_85950_(r, g, b, a).m_5752_();
            bufferbuilder.m_252986_(matrix, -100.0f, -100.0f, 100.0f).m_85950_(r, g, b, a).m_5752_();
            bufferbuilder.m_252986_(matrix, 100.0f, -100.0f, 100.0f).m_85950_(r, g, b, a).m_5752_();
            bufferbuilder.m_252986_(matrix, 100.0f, -100.0f, -100.0f).m_85950_(r, g, b, a).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            RenderSystem.disableBlend();
        }
    }

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        if (RadioactiveFogHandler.isRadioactiveFogActive(event.getCamera())) {
            event.setCanceled(true);
            event.setNearPlaneDistance(0.0f);
            event.setFarPlaneDistance(24.0f);
            event.setFogShape(FogShape.SPHERE);
        }
    }

    private static void updateMovementDirection(Entity entity) {
        double deltaX = entity.m_20185_() - prevX;
        double deltaZ = entity.m_20189_() - prevZ;
        prevX = entity.m_20185_();
        prevZ = entity.m_20189_();
        double movementMagnitude = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        if (movementMagnitude > 0.05) {
            double dirMagnitude = Math.sqrt((movingDirX = movingDirX * (double)0.8f + deltaX * 0.19999998807907104) * movingDirX + (movingDirZ = movingDirZ * (double)0.8f + deltaZ * 0.19999998807907104) * movingDirZ);
            if (dirMagnitude > 0.0) {
                movingDirX /= dirMagnitude;
                movingDirZ /= dirMagnitude;
            }
            if (entity.m_9236_().m_213780_().m_188501_() < 0.01f) {
                Radioactive.LOGGER.info("Movement direction: X=" + movingDirX + ", Z=" + movingDirZ);
            }
        }
    }

    private static void spawnFogParticles(ClientLevel level, double x, double y, double z, double playerEyeHeight) {
        int groundHeight = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, (int)x, (int)z);
        float heightOffset = minHeightAboveGround + level.f_46441_.m_188501_() * (maxHeightAboveGround - minHeightAboveGround);
        double spawnHeight = (float)groundHeight + heightOffset;
        if (enforceHeightLimit) {
            double heightRelativeToPlayer = spawnHeight - playerEyeHeight;
            if (heightRelativeToPlayer > (double)maxHeightAbovePlayer) {
                return;
            }
            if (level.m_213780_().m_188501_() < 0.01f) {
                Radioactive.LOGGER.info("Spawn height info - Ground: " + groundHeight + ", Spawn: " + spawnHeight + ", Player eye: " + playerEyeHeight + ", Relative: " + heightRelativeToPlayer);
            }
        }
        level.m_7106_((ParticleOptions)Radioactive.RAD_FOG.get(), x, spawnHeight, z, 0.0, 0.0, 0.0);
        if (level.f_46441_.m_188501_() < 0.1f) {
            RadioactiveFogHandler.createHotspot(level, x, spawnHeight, z, playerEyeHeight);
        }
    }

    private static void createHotspot(ClientLevel level, double x, double y, double z, double playerEyeHeight) {
        RandomSource rand = level.m_213780_();
        int extraCount = 3 + rand.m_188503_(3);
        for (int j = 0; j < extraCount; ++j) {
            double offsetX = x + ((double)rand.m_188501_() - 0.5) * 8.0;
            double offsetZ = z + ((double)rand.m_188501_() - 0.5) * 8.0;
            double offsetY = y + ((double)rand.m_188501_() - 0.5) * 2.0;
            if (enforceHeightLimit && offsetY > playerEyeHeight + (double)maxHeightAbovePlayer) continue;
            level.m_7106_((ParticleOptions)Radioactive.RAD_FOG.get(), offsetX, offsetY, offsetZ, 0.01 - (double)rand.m_188501_() * 0.02, 0.005 - (double)rand.m_188501_() * 0.01, 0.01 - (double)rand.m_188501_() * 0.02);
        }
    }

    private static void update(ClientLevel level, Entity entity) {
        RandomSource rand = level.m_213780_();
        double playerEyeHeight = entity.m_20188_();
        double focusX = entity.m_20185_() + movingDirX * (double)predictiveFactor * 60.0;
        double focusZ = entity.m_20189_() + movingDirZ * (double)predictiveFactor * 60.0;
        int particlesToSpawn = 25 + rand.m_188503_(15);
        for (int i = 0; i < particlesToSpawn; ++i) {
            double spawnZ;
            double spawnX;
            boolean predictiveSpawn;
            float theta = (float)(Math.PI * 2 * (double)rand.m_188501_());
            float phi = (float)Math.acos(2.0f * rand.m_188501_() - 1.0f);
            float distance = minDistance + rand.m_188501_() * (maxDistance - minDistance);
            double x = distance * Mth.m_14031_((float)phi) * Mth.m_14089_((float)theta);
            double y = distance * Mth.m_14031_((float)phi) * Mth.m_14031_((float)theta);
            double z = distance * Mth.m_14089_((float)phi);
            boolean bl = predictiveSpawn = rand.m_188501_() < 0.7f;
            if (predictiveSpawn && (movingDirX != 0.0 || movingDirZ != 0.0)) {
                spawnX = focusX + x * 0.7;
                spawnZ = focusZ + z * 0.7;
            } else {
                spawnX = entity.m_20185_() + x;
                spawnZ = entity.m_20189_() + z;
            }
            pos.m_122178_((int)spawnX, (int)(y + entity.m_20186_()), (int)spawnZ);
            if (level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()) > pos.m_123342_()) continue;
            RadioactiveFogHandler.spawnFogParticles(level, (float)pos.m_123341_() + (rand.m_188501_() - 0.5f) * 2.0f, pos.m_123342_(), (float)pos.m_123343_() + (rand.m_188501_() - 0.5f) * 2.0f, playerEyeHeight);
        }
    }

    private static boolean isRadioactiveFogActive(Camera camera) {
        if (camera == null) {
            return false;
        }
        return camera.m_90592_().m_9236_().m_46472_() == Level.f_46428_ && isFogActive;
    }

    public static void setFogActive(boolean fogActive) {
        Radioactive.LOGGER.info("Setting fog active: " + fogActive);
        isFogActive = fogActive;
    }

    public static void setMaxHeightAbovePlayer(float maxHeight) {
        maxHeightAbovePlayer = maxHeight;
        Radioactive.LOGGER.info("Set fog max height: " + maxHeight + " blocks relative to player eye level");
    }

    public static void setHeightAboveGround(float minHeight, float maxHeight) {
        minHeightAboveGround = minHeight;
        maxHeightAboveGround = maxHeight;
        Radioactive.LOGGER.info("Set fog height range: " + minHeight + " to " + maxHeight + " blocks above ground");
    }

    public static void setEnforceHeightLimit(boolean enforce) {
        enforceHeightLimit = enforce;
        Radioactive.LOGGER.info("Height restriction " + (enforce ? "enabled" : "disabled"));
    }

    public static void setPredictiveFactor(float factor) {
        predictiveFactor = factor;
        Radioactive.LOGGER.info("Predictive factor set to: " + factor);
    }

    public static void setSpawnDistanceRange(float min, float max) {
        minDistance = min;
        maxDistance = max;
        Radioactive.LOGGER.info("Spawn distance range set to: " + min + " - " + max + " blocks");
    }
}

