/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.client.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.radar.radioactive.client.overlay.IRadiationUIUpdater;
import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.items.ItemGeigerCounter;
import com.radar.radioactive.common.registry.ModItems;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class GeigerOverlay
implements IRadiationUIUpdater {
    public static final GeigerOverlay INSTANCE = new GeigerOverlay();
    private final ResourceLocation GEIGER_BAR = new ResourceLocation("radioactive", "textures/gui/geiger_bar.png");
    private final ResourceLocation GEIGER_BAR_OVER = new ResourceLocation("radioactive", "textures/gui/geiger_bar_over.png");
    private final ResourceLocation GEIGER_GAUGE_UNDER = new ResourceLocation("radioactive", "textures/gui/geiger_gauge.png");
    private final ResourceLocation GEIGER_GAUGE_OVER = new ResourceLocation("radioactive", "textures/gui/geiger_gauge_over.png");
    private final ResourceLocation GEIGER_GAUGE_NEEDLE = new ResourceLocation("radioactive", "textures/gui/geiger_gauge_needle.png");
    private final int SAFE_COLOR = 65280;
    private final int WARNING_COLOR = 0xFFFF00;
    private final int DANGER_COLOR = 0xFF0000;
    private final int BACKGROUND_COLOR = -1879048192;
    private final float TWEEN_FACTOR = 0.05f;
    private final float MAX_NOISE_AMPLITUDE = 0.75f;
    private final Random random = new Random();
    private float storedRadiation;
    private float exposureRate;
    private float effectiveRate;
    private float currentExposureAngle = 0.0f;
    private float targetExposureAngle = 0.0f;
    private float currentEffectiveAngle = 0.0f;
    private float targetEffectiveAngle = 0.0f;
    private float exposureNoise = 0.0f;
    private float effectiveNoise = 0.0f;
    public final IGuiOverlay HUD_GEIGER = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (this.hasGeigerCounter((Player)player)) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            float guiScale = (float)Minecraft.m_91087_().m_91268_().m_85449_();
            this.renderPersonalData(guiGraphics, screenWidth, screenHeight, guiScale);
            this.renderGeigerCounterGauge(guiGraphics, screenWidth, screenHeight, guiScale);
            this.updateNeedleAngles();
            poseStack.m_85849_();
        }
    };

    private GeigerOverlay() {
    }

    private boolean hasGeigerCounter(Player player) {
        if (player.m_21205_().m_41720_() instanceof ItemGeigerCounter || player.m_21206_().m_41720_() instanceof ItemGeigerCounter) {
            return true;
        }
        for (int i = 0; i < 9; ++i) {
            if (!(player.m_150109_().m_8020_(i).m_41720_() instanceof ItemGeigerCounter)) continue;
            return true;
        }
        return this.checkCuriosEquipped(player);
    }

    private boolean checkCuriosEquipped(Player player) {
        ICuriosItemHandler curiosInventory = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).resolve().get();
        return curiosInventory.isEquipped((Item)ModItems.GEIGER_COUNTER.get());
    }

    private void renderPersonalData(GuiGraphics guiGraphics, int screenWidth, int screenHeight, float guiScale) {
        int baseX = 10;
        int baseY = 50;
        int x = baseX;
        int y = screenHeight - baseY;
        double maxRadiation = (Double)RadioactiveCommonConfigs.MAX_RADIATION.get();
        double fillAmount = Math.min((double)this.storedRadiation / maxRadiation, 1.0);
        int fillWidth = (int)(110.0 * fillAmount);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GEIGER_BAR);
        guiGraphics.m_280163_(this.GEIGER_BAR, x, y, 0.0f, 0.0f, fillWidth, 26, 110, 26);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GEIGER_BAR_OVER);
        guiGraphics.m_280163_(this.GEIGER_BAR_OVER, x, y, 0.0f, 0.0f, 110, 26, 110, 26);
        RenderSystem.disableBlend();
    }

    public void renderGeigerCounterGauge(GuiGraphics guiGraphics, int screenWidth, int screenHeight, float guiScale) {
        int baseX = 10;
        int baseY = 110;
        int x = baseX;
        int y = screenHeight - baseY;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GEIGER_GAUGE_UNDER);
        guiGraphics.m_280163_(this.GEIGER_GAUGE_UNDER, x, y, 0.0f, 0.0f, 108, 59, 108, 59);
        this.drawNeedle(guiGraphics, x, y, this.currentExposureAngle, this.exposureNoise, -1);
        this.drawNeedle(guiGraphics, x, y, this.currentEffectiveAngle, this.effectiveNoise, -65536);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GEIGER_GAUGE_OVER);
        guiGraphics.m_280163_(this.GEIGER_GAUGE_OVER, x, y, 0.0f, 0.0f, 108, 59, 108, 59);
        int textY = y + 88;
        int textColor = this.getRadiationColor(this.effectiveRate);
        MutableComponent displayText = Component.m_237110_((String)"overlay.radioactive.geiger_counter", (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.effectiveRate)), String.format("%.1f", Float.valueOf(this.exposureRate))});
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92852_((FormattedText)displayText);
        int textX = x + (108 - textWidth) / 2;
        Objects.requireNonNull(font);
        guiGraphics.m_280509_(textX - 2, textY - 1, textX + textWidth + 2, textY + 9 + 1, -1879048192);
        guiGraphics.m_280430_(font, (Component)displayText, textX, textY, textColor);
        RenderSystem.disableBlend();
    }

    private void drawNeedle(GuiGraphics guiGraphics, int gaugeX, int gaugeY, float currentAngle, float noise, int argbColor) {
        float totalAngle = currentAngle + noise;
        float needleRadians = (float)Math.toRadians(totalAngle);
        float pivotX = gaugeX + 54;
        float pivotY = gaugeY + 54 + 24;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(pivotX, pivotY, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252961_(needleRadians));
        poseStack.m_252880_(-1.0f, -58.0f, 0.0f);
        float a = (float)(argbColor >> 24 & 0xFF) / 255.0f;
        float r = (float)(argbColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(argbColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(argbColor & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GEIGER_GAUGE_NEEDLE);
        guiGraphics.m_280163_(this.GEIGER_GAUGE_NEEDLE, 0, 0, 0.0f, 0.0f, 2, 59, 2, 59);
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int getRadiationColor(float radiation) {
        if (radiation <= 1.0f) {
            return 65280;
        }
        if (radiation <= 5.0f) {
            return 0xFFFF00;
        }
        return 0xFF0000;
    }

    @Override
    public void update(float stored, float exposure, float effective) {
        this.storedRadiation = stored;
        this.exposureRate = exposure;
        this.effectiveRate = effective;
        this.targetExposureAngle = this.calculateNeedleAngle(this.exposureRate);
        this.targetEffectiveAngle = this.calculateNeedleAngle(this.effectiveRate);
    }

    private float calculateNeedleAngle(float rate) {
        float MIN_ANGLE_DEG = -47.0f;
        float MAX_ANGLE_DEG = 47.0f;
        float MAX_EXPOSURE = 120.0f;
        float clamped = Math.max(0.0f, Math.min(rate, 120.0f));
        float normalized = clamped / 120.0f;
        return -47.0f + normalized * 94.0f;
    }

    private void updateNeedleAngles() {
        this.currentExposureAngle = this.lerp(this.currentExposureAngle, this.targetExposureAngle, 0.05f);
        this.currentEffectiveAngle = this.lerp(this.currentEffectiveAngle, this.targetEffectiveAngle, 0.05f);
        if (this.exposureRate == 0.0f) {
            this.exposureNoise = 0.0f;
            this.effectiveNoise = 0.0f;
        } else {
            this.exposureNoise = (this.random.nextFloat() * 2.0f - 1.0f) * 0.75f;
            this.effectiveNoise = (this.random.nextFloat() * 2.0f - 1.0f) * 0.75f;
        }
    }

    private float lerp(float a, float b, float factor) {
        return a + factor * (b - a);
    }
}

