/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.client.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.radar.radioactive.client.RadioactiveClient;
import com.radar.radioactive.client.overlay.IRadiationUIUpdater;
import com.radar.radioactive.common.items.ItemShoddyGeigerCounter;
import com.radar.radioactive.common.registry.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Matrix4f;
import top.theillusivec4.curios.api.CuriosApi;

public class VacuumTubeOverlay
implements IRadiationUIUpdater {
    public static final VacuumTubeOverlay INSTANCE = new VacuumTubeOverlay();
    private static final ResourceLocation VACUUM_TUBE_TEXTURE = new ResourceLocation("radioactive", "textures/gui/vacuum_tube.png");
    private static final ResourceLocation VACUUM_TUBE_MASK = new ResourceLocation("radioactive", "textures/gui/vacuum_tube_mask.png");
    private static final ResourceLocation VACUUM_TUBE_BROKEN_TEXTURE = new ResourceLocation("radioactive", "textures/gui/vacuum_tube_broken.png");
    private static final int TUBE_WIDTH = 52;
    private static final int TUBE_HEIGHT = 50;
    private float effectiveRate;
    private boolean broken = false;
    public final IGuiOverlay HUD_VACUUM_TUBE = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !this.hasVacuumTube((Player)player)) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        int tubeX = 5;
        int tubeY = screenHeight - 50 - 10;
        float maxGlowValue = 30.0f;
        if (this.broken) {
            this.renderBrokenVacuumTube(guiGraphics, tubeX, tubeY, this.effectiveRate, maxGlowValue);
            poseStack.m_85849_();
            return;
        }
        VacuumTubeOverlay.renderVacuumTubeWithShader(guiGraphics, tubeX, tubeY, this.effectiveRate, maxGlowValue, partialTick);
        poseStack.m_85849_();
    };

    private VacuumTubeOverlay() {
    }

    private void renderBrokenVacuumTube(GuiGraphics guiGraphics, int x, int y, float value, float maxValue) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(VACUUM_TUBE_BROKEN_TEXTURE, x, y, 0.0f, 0.0f, 52, 50, 52, 50);
        RenderSystem.disableBlend();
    }

    private static void renderVacuumTubeWithShader(GuiGraphics guiGraphics, int x, int y, float value, float maxValue, float partialTick) {
        ShaderInstance shader = RadioactiveClient.getVacuumTubeShader();
        if (shader == null) {
            guiGraphics.m_280163_(VACUUM_TUBE_TEXTURE, x, y, 0.0f, 0.0f, 52, 50, 52, 50);
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(() -> shader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)VACUUM_TUBE_TEXTURE);
        RenderSystem.setShaderTexture((int)1, (ResourceLocation)VACUUM_TUBE_MASK);
        float brightness = Math.min(value / maxValue, 1.0f);
        shader.m_173348_("GlowIntensity").m_5985_(brightness);
        shader.m_173348_("GlowColor").m_5805_(0.3f, 0.6f, 1.0f, 1.0f);
        if (shader.m_173348_("Time") != null) {
            float time = ((float)Minecraft.m_91087_().f_91073_.m_46467_() + partialTick) / 20.0f;
            shader.m_173348_("Time").m_5985_(time);
        }
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x, (float)(y + 50), 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)(x + 52), (float)(y + 50), 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)(x + 52), (float)y, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.disableBlend();
    }

    @Override
    public void update(float storedRadiation, float exposureRate, float effectiveRate) {
        this.effectiveRate = effectiveRate;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }

    private boolean hasVacuumTube(Player player) {
        if (player.m_21205_().m_41720_() instanceof ItemShoddyGeigerCounter || player.m_21206_().m_41720_() instanceof ItemShoddyGeigerCounter) {
            return true;
        }
        for (int i = 0; i < 9; ++i) {
            if (!(player.m_150109_().m_8020_(i).m_41720_() instanceof ItemShoddyGeigerCounter)) continue;
            return true;
        }
        return this.checkCuriosEquipped(player);
    }

    private boolean checkCuriosEquipped(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(handler -> handler.isEquipped((Item)ModItems.SHODDY_GEIGER_COUNTER.get())).orElse(false);
    }
}

