/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class RadFogParticle
extends TextureSheetParticle {
    private static final float BASE_RED = 0.34f;
    private static final float BASE_GREEN = 0.55f;
    private static final float BASE_BLUE = 0.34f;
    private static final float MAX_DISTANCE_SQ = 128.0f;
    private static final float FADE_START_DISTANCE_SQ = 102.4f;
    private final float hueVariationSpeed;
    private final float hueVariationAmount;
    private final float pulseFrequency;
    protected BlockPos.MutableBlockPos pos;
    private boolean shouldFadeOut;
    private final float xVelocity;
    private final float zVelocity;
    private final float swirlingIntensity;

    public RadFogParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z);
        this.f_107225_ = 2000 + level.m_213780_().m_188503_(2000);
        this.f_107663_ = 4.0f + level.f_46441_.m_188501_() * 8.0f;
        this.m_108337_(spriteSet.m_213979_(level.m_213780_()));
        this.pos = new BlockPos.MutableBlockPos(x, y, z);
        this.m_108339_(spriteSet);
        Color color = new Color(0.12f, 0.25f, 0.15f);
        this.f_107227_ = (float)color.getRed() / 255.0f;
        this.f_107228_ = (float)color.getGreen() / 255.0f;
        this.f_107229_ = (float)color.getBlue() / 255.0f;
        this.f_107230_ = 0.0f;
        this.f_107204_ = this.f_107231_ = level.f_46441_.m_188501_() * (float)Math.PI;
        Random rand = new Random();
        this.hueVariationSpeed = 0.1f + rand.nextFloat() * 0.1f;
        this.hueVariationAmount = 0.05f + rand.nextFloat() * 0.05f;
        this.pulseFrequency = 0.05f + rand.nextFloat() * 0.2f;
        this.xVelocity = (this.f_107223_.m_188501_() - 0.5f) / 100.0f;
        this.zVelocity = (this.f_107223_.m_188501_() - 0.5f) / 100.0f;
        this.swirlingIntensity = 0.001f + rand.nextFloat() * 0.002f;
    }

    public void m_5989_() {
        super.m_5989_();
        this.pos.m_122169_(this.f_107212_, this.f_107213_ - 0.2, this.f_107214_);
        this.f_107215_ = this.xVelocity;
        this.f_107217_ = this.zVelocity;
        float swirlingX = (float)Math.sin((float)this.f_107224_ * 0.01f) * this.swirlingIntensity;
        float swirlingZ = (float)Math.cos((float)this.f_107224_ * 0.01f) * this.swirlingIntensity;
        this.f_107215_ += (double)swirlingX;
        this.f_107217_ += (double)swirlingZ;
        if (this.f_107208_.m_8055_((BlockPos)this.pos).m_280296_()) {
            this.m_107274_();
            return;
        }
        if (this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        this.removeIfTooFar();
        if (this.shouldFadeOut) {
            this.fadeOut();
        } else {
            this.fadeIn();
        }
        this.updateDustColor();
    }

    private void fadeIn() {
        this.f_107230_ = this.f_107224_ < 20 ? (float)this.f_107224_ / 20.0f : Math.min(1.0f, this.f_107230_ + 0.01f);
    }

    private void fadeOut() {
        this.f_107230_ *= 0.97f;
        if (this.f_107230_ <= 0.01f) {
            this.m_107274_();
        }
    }

    private void updateDustColor() {
        float baseOscillation = (float)Math.sin((float)this.f_107224_ * this.hueVariationSpeed) * this.hueVariationAmount;
        float pulseOscillation = (float)Math.sin((float)this.f_107224_ * this.pulseFrequency) * 0.15f;
        float combinedEffect = baseOscillation + pulseOscillation;
        this.f_107227_ = Mth.m_14036_((float)(0.34f + combinedEffect * 0.7f), (float)0.0f, (float)1.0f);
        this.f_107228_ = Mth.m_14036_((float)(0.55f + combinedEffect), (float)0.0f, (float)1.0f);
        this.f_107229_ = Mth.m_14036_((float)(0.34f + combinedEffect * 0.8f), (float)0.0f, (float)1.0f);
    }

    private void removeIfTooFar() {
        Entity cameraEntity = Minecraft.m_91087_().m_91288_();
        if (cameraEntity != null) {
            double dz;
            double dy;
            double dx = this.f_107212_ - cameraEntity.m_20185_();
            double distSq = dx * dx + (dy = this.f_107213_ - cameraEntity.m_20186_()) * dy + (dz = this.f_107214_ - cameraEntity.m_20189_()) * dz;
            if (distSq > (double)102.4f) {
                float fadeFactor = (float)((distSq - (double)102.4f) / 25.599998474121094);
                fadeFactor = Mth.m_14036_((float)fadeFactor, (float)0.0f, (float)1.0f);
                this.f_107230_ = Mth.m_14179_((float)fadeFactor, (float)this.f_107230_, (float)0.0f);
                if (this.f_107230_ < 0.2f) {
                    this.shouldFadeOut = true;
                }
                if (distSq > (double)153.6f) {
                    this.m_107274_();
                }
            }
        } else {
            this.shouldFadeOut = true;
        }
    }

    public int m_6355_(float partialTick) {
        int i = super.m_6355_(partialTick);
        int j = 240;
        int k = i >> 16 & 0xFF;
        return j | k << 16;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_108339_(SpriteSet sprite) {
        super.m_108337_(sprite.m_5819_(this.f_107224_, this.f_107225_));
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Vec3 camPos = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        boolean cameraBelow = camPos.f_82480_ < this.f_107213_;
        Quaternionf quaternion = cameraBelow ? new Quaternionf().rotationX(-1.5707964f) : new Quaternionf().rotationX(1.5707964f);
        float rollAngle = Mth.m_14179_((float)partialTick, (float)this.f_107204_, (float)this.f_107231_);
        Quaternionf rollQuat = new Quaternionf().rotationZ(rollAngle);
        quaternion.mul((Quaternionfc)rollQuat);
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y, z, partialTick);
    }

    public void renderRotatedQuad(VertexConsumer vertexConsumer, Quaternionf quaternion, float x, float y, float z, float tickPercentage) {
        float quadSize = this.m_5902_(tickPercentage);
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int lightColor = this.m_6355_(tickPercentage);
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int k = 0; k < 4; ++k) {
            Vector3f vector3f = vector3fs[k];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(quadSize);
            vector3f.add(x, y, z);
        }
        vertexConsumer.m_5483_((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightColor).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightColor).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightColor).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightColor).m_5752_();
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public DefaultFactory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new RadFogParticle(level, x, y, z, this.provider);
        }
    }
}

