/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.client.renderer;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChunkBorderRenderer {
    @OnlyIn(value=Dist.CLIENT)
    public static void renderChunkBorders(Level level, ChunkPos chunkPos) {
        if (level.f_46441_.m_188501_() < 0.3f) {
            int minX = chunkPos.m_45604_();
            int maxX = chunkPos.m_45608_();
            int minZ = chunkPos.m_45605_();
            int maxZ = chunkPos.m_45609_();
            int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, minX, minZ);
            for (int x = minX; x <= maxX; x += 4) {
                if (!(level.f_46441_.m_188501_() < 0.3f)) continue;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)x, (double)y + 0.1, (double)minZ, 0.0, 0.05, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)x, (double)y + 0.1, (double)maxZ, 0.0, 0.05, 0.0);
            }
            for (int z = minZ; z <= maxZ; z += 4) {
                if (!(level.f_46441_.m_188501_() < 0.3f)) continue;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)minX, (double)y + 0.1, (double)z, 0.0, 0.05, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)maxX, (double)y + 0.1, (double)z, 0.0, 0.05, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderBorderEdge(Level level, ChunkPos chunkPos, Direction direction) {
        int minX = chunkPos.m_45604_();
        int maxX = chunkPos.m_45608_();
        int minZ = chunkPos.m_45605_();
        int maxZ = chunkPos.m_45609_();
        int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, minX, minZ);
        switch (direction) {
            case NORTH: {
                for (int x = minX; x <= maxX; x += 4) {
                    if (!(level.f_46441_.m_188501_() < 0.3f)) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)x, (double)y + 0.1, (double)minZ, 0.0, 0.05, 0.0);
                }
                break;
            }
            case SOUTH: {
                for (int x = minX; x <= maxX; x += 4) {
                    if (!(level.f_46441_.m_188501_() < 0.3f)) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)x, (double)y + 0.1, (double)maxZ, 0.0, 0.05, 0.0);
                }
                break;
            }
            case EAST: {
                for (int z = minZ; z <= maxZ; z += 4) {
                    if (!(level.f_46441_.m_188501_() < 0.3f)) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)maxX, (double)y + 0.1, (double)z, 0.0, 0.05, 0.0);
                }
                break;
            }
            case WEST: {
                for (int z = minZ; z <= maxZ; z += 4) {
                    if (!(level.f_46441_.m_188501_() < 0.3f)) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)minX, (double)y + 0.1, (double)z, 0.0, 0.05, 0.0);
                }
                break;
            }
        }
    }
}

