/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.client.renderer;

import com.radar.radioactive.client.renderer.ChunkBorderRenderer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SafeChunkRenderer {
    private static final Set<ChunkPos> safeChunksClient = ConcurrentHashMap.newKeySet();

    public static void setChunkSafe(ChunkPos pos, boolean isSafe) {
        if (isSafe) {
            safeChunksClient.add(pos);
        } else {
            safeChunksClient.remove(pos);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        for (ChunkPos safePos : safeChunksClient) {
            if (!safeChunksClient.contains(new ChunkPos(safePos.f_45578_ + 1, safePos.f_45579_))) {
                ChunkBorderRenderer.renderBorderEdge((Level)level, safePos, Direction.EAST);
            }
            if (!safeChunksClient.contains(new ChunkPos(safePos.f_45578_ - 1, safePos.f_45579_))) {
                ChunkBorderRenderer.renderBorderEdge((Level)level, safePos, Direction.WEST);
            }
            if (!safeChunksClient.contains(new ChunkPos(safePos.f_45578_, safePos.f_45579_ + 1))) {
                ChunkBorderRenderer.renderBorderEdge((Level)level, safePos, Direction.SOUTH);
            }
            if (safeChunksClient.contains(new ChunkPos(safePos.f_45578_, safePos.f_45579_ - 1))) continue;
            ChunkBorderRenderer.renderBorderEdge((Level)level, safePos, Direction.NORTH);
        }
    }
}

