/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common;

import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.network.NetworkHandler;
import com.radar.radioactive.common.radiation.RadiationRegistry;
import com.radar.radioactive.common.recipe.ingredient.ArmorTierIngredient;
import com.radar.radioactive.common.registry.ModAttributes;
import com.radar.radioactive.common.registry.ModBlockEntities;
import com.radar.radioactive.common.registry.ModBlocks;
import com.radar.radioactive.common.registry.ModEffects;
import com.radar.radioactive.common.registry.ModEnchantments;
import com.radar.radioactive.common.registry.ModEntities;
import com.radar.radioactive.common.registry.ModItems;
import com.radar.radioactive.common.registry.ModMenuTypes;
import com.radar.radioactive.common.registry.ModRecipeSerializers;
import com.radar.radioactive.common.registry.ModSounds;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="radioactive")
public class Radioactive {
    public static final String MODID = "radioactive";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"radioactive");
    public static final RegistryObject<CreativeModeTab> RADIOACTIVE_TAB = CREATIVE_MODE_TABS.register("radioactive_tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.radioactive")).m_257737_(() -> ((Item)ModItems.GEIGER_COUNTER.get()).m_7968_()).m_257501_((parameters, output) -> {
        output.m_246326_((ItemLike)ModItems.GEIGER_COUNTER.get());
        output.m_246326_((ItemLike)ModItems.SHODDY_GEIGER_COUNTER.get());
        output.m_246326_((ItemLike)ModItems.INDUSTRIAL_TONGS.get());
        output.m_246326_((ItemLike)ModItems.RADAWAY_BASIC.get());
        output.m_246326_((ItemLike)ModItems.RADAWAY_ADVANCED.get());
        output.m_246326_((ItemLike)ModItems.RADAWAY_ULTIMATE.get());
        output.m_246326_((ItemLike)ModItems.RADX_BASIC.get());
        output.m_246326_((ItemLike)ModItems.ANTI_RAD_TIER_1.get());
        output.m_246326_((ItemLike)ModItems.ANTI_RAD_TIER_2.get());
        output.m_246326_((ItemLike)ModItems.ANTI_RAD_TIER_3.get());
        output.m_246326_((ItemLike)ModBlocks.DECONTAMINATOR.get());
        output.m_246326_((ItemLike)ModBlocks.RADIATION_ABSORBER_TIER_1.get());
        output.m_246326_((ItemLike)ModBlocks.RADIATION_ABSORBER_TIER_2.get());
        output.m_246326_((ItemLike)ModBlocks.RADIATION_ABSORBER_TIER_CREATIVE.get());
        output.m_246326_((ItemLike)ModItems.RADIOACTIVE_TEST_ITEM.get());
        output.m_246326_((ItemLike)ModItems.URANIUM_TEST_ITEM.get());
        output.m_246326_((ItemLike)ModBlocks.RADIOACTIVE_TEST_BLOCK.get());
    }).m_257652_());
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"radioactive");
    public static final RegistryObject<SimpleParticleType> DECONTAMINATION_PARTICLE = PARTICLE_TYPES.register("decontamination_particle", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> RAD_FOG = PARTICLE_TYPES.register("rad_fog", () -> new SimpleParticleType(true));

    public Radioactive() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RadioactiveCommonConfigs.SPEC, "radioactive-common.toml");
        ModRecipeSerializers.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModEnchantments.register(modEventBus);
        ModEntities.register(modEventBus);
        ModSounds.register(modEventBus);
        ModEffects.register(modEventBus);
        ModAttributes.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        PARTICLE_TYPES.register(modEventBus);
        NetworkHandler.register();
        modEventBus.addListener(this::onConfigReloading);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(RadiationRegistry.class);
        LOGGER.info("Radioactive mod initialized");
        modEventBus.addListener(this::commonSetup);
    }

    private void onConfigReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == RadioactiveCommonConfigs.SPEC) {
            LOGGER.info("Radioactive configs reloaded - reinitializing radiation system");
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CraftingHelper.register((ResourceLocation)ArmorTierIngredient.NAME, (IIngredientSerializer)ArmorTierIngredient.Serializer.INSTANCE));
    }
}

