/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.blockentities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPoweredBlockEntity
extends BlockEntity
implements MenuProvider {
    protected final ItemStackHandler itemHandler;
    protected final EnergyStorage energyStorage;
    protected LazyOptional<IItemHandler> lazyItemHandler;
    protected LazyOptional<IEnergyStorage> lazyEnergyHandler;
    protected int progress;
    protected int maxProgress;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> AbstractPoweredBlockEntity.this.progress;
                case 1 -> AbstractPoweredBlockEntity.this.maxProgress;
                case 2 -> AbstractPoweredBlockEntity.this.energyStorage.getEnergyStored();
                case 3 -> AbstractPoweredBlockEntity.this.energyStorage.getMaxEnergyStored();
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractPoweredBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    AbstractPoweredBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public AbstractPoweredBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int itemSlots, int energyCapacity, int maxTransfer, boolean isCreative) {
        super(type, pos, state);
        this.itemHandler = new ItemStackHandler(itemSlots);
        this.energyStorage = isCreative ? new CreativeEnergyStorage() : new EnergyStorage(energyCapacity, maxTransfer);
        this.lazyItemHandler = LazyOptional.empty();
        this.lazyEnergyHandler = LazyOptional.empty();
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(Level level, BlockPos pos, BlockState state) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyHandler = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("machine.progress", this.progress);
        nbt.m_128405_("machine.maxProgress", this.maxProgress);
        nbt.m_128405_("machine.energyStored", this.energyStorage.getEnergyStored());
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("machine.progress");
        this.maxProgress = nbt.m_128451_("machine.maxProgress");
        int stored = nbt.m_128451_("machine.energyStored");
        this.energyStorage.receiveEnergy(stored, false);
    }

    public void m_7651_() {
        super.m_7651_();
    }

    @NotNull
    public abstract Component m_5446_();

    @Nullable
    public abstract AbstractContainerMenu m_7208_(int var1, @NotNull Inventory var2, @NotNull Player var3);

    public ContainerData getContainerData() {
        return this.data;
    }

    private static class CreativeEnergyStorage
    extends EnergyStorage {
        public CreativeEnergyStorage() {
            super(50000);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return maxReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return maxExtract;
        }

        public int getEnergyStored() {
            return this.getMaxEnergyStored();
        }
    }
}

