/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.blockentities;

import com.radar.radioactive.client.sound.DecontaminatorSoundInstance;
import com.radar.radioactive.common.blockentities.AbstractPoweredBlockEntity;
import com.radar.radioactive.common.menu.DecontaminatorMenu;
import com.radar.radioactive.common.radiation.RadiationHelper;
import com.radar.radioactive.common.registry.ModBlockEntities;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecontaminatorBlockEntity
extends AbstractPoweredBlockEntity {
    private static final int ENERGY_USAGE_PER_TICK = 20;
    private static final int DECONTAMINATION_SIZE = 3;
    private static final float RADIATION_REDUCTION_PER_TICK = 5.0f;
    private static final Random RANDOM = new Random();
    private static final int PARTICLES_PER_TICK = 3;
    private static final double PARTICLE_SPEED = 0.05;
    private static final double PARTICLE_SPREAD = 0.25;
    @OnlyIn(value=Dist.CLIENT)
    private DecontaminatorSoundInstance decontaminatorSound;

    public DecontaminatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DECONTAMINATOR.get(), pos, state, 0, 10000, 100, false);
        this.maxProgress = 78;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DecontaminatorBlockEntity entity) {
        if (level.m_5776_()) {
            entity.clientTick(level, pos, state);
        } else {
            entity.serverTick(level, pos, state);
        }
    }

    private static AABB getDecontaminationArea(BlockPos pos) {
        return new AABB(pos.m_7918_(-1, 1, -1), pos.m_7918_(2, 4, 2));
    }

    private static void spawnDecontaminationParticles(Level level, BlockPos pos, BlockState state) {
        Direction facing = Direction.UP;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        x += (double)facing.m_122429_() * 0.55;
        y += (double)facing.m_122430_() * 0.55;
        z += (double)facing.m_122431_() * 0.55;
        for (int i = 0; i < 3; ++i) {
            double spreadX = 0.0;
            double spreadY = 0.0;
            double spreadZ = 0.0;
            if (facing.m_122434_() != Direction.Axis.X) {
                spreadX = (RANDOM.nextDouble() - 0.5) * 0.25;
            }
            if (facing.m_122434_() != Direction.Axis.Y) {
                spreadY = (RANDOM.nextDouble() - 0.5) * 0.25;
            }
            if (facing.m_122434_() != Direction.Axis.Z) {
                spreadZ = (RANDOM.nextDouble() - 0.5) * 0.25;
            }
            double motionX = (double)facing.m_122429_() * 0.05;
            double motionY = (double)facing.m_122430_() * 0.05;
            double motionZ = (double)facing.m_122431_() * 0.05;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123806_, x + spreadX, y + spreadY, z + spreadZ, motionX += (RANDOM.nextDouble() - 0.5) * 0.01, motionY += (RANDOM.nextDouble() - 0.5) * 0.01, motionZ += (RANDOM.nextDouble() - 0.5) * 0.01);
        }
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        boolean hasRedstoneSignal = level.m_276867_(pos);
        if (hasRedstoneSignal && this.hasEnoughEnergy()) {
            this.energyStorage.extractEnergy(20, false);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
            AABB area = DecontaminatorBlockEntity.getDecontaminationArea(pos);
            List playersInRange = level.m_45976_(Player.class, area);
            for (Player player : playersInRange) {
                float currentRadiation = RadiationHelper.getRadiation((LivingEntity)player);
                if (!(currentRadiation > 0.0f)) continue;
                RadiationHelper.addRadiation((LivingEntity)player, -5.0f);
            }
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private boolean hasEnoughEnergy() {
        return this.energyStorage.getEnergyStored() >= 20;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            DecontaminatorBlockEntity.spawnDecontaminationParticles(level, pos, state);
            if (this.decontaminatorSound == null || this.decontaminatorSound.m_7801_()) {
                this.decontaminatorSound = new DecontaminatorSoundInstance(this);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.decontaminatorSound);
            }
        }
    }

    @Override
    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.radioactive.decontaminator");
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new DecontaminatorMenu(id, inv, this, this.getContainerData());
    }

    @Override
    public void drops() {
        super.drops();
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
    }
}

