/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.radar.radioactive.common.radiation.RadiationHelper;
import com.radar.radioactive.common.radiation.capabilities.IRadiationCapability;
import com.radar.radioactive.common.radiation.capabilities.RadiationProvider;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class RadiationCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)Component.m_237115_((String)"command.radioactive.radiation").getString()).requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)Component.m_237115_((String)"command.radioactive.player").getString()).then(Commands.m_82127_((String)Component.m_237115_((String)"command.radioactive.set").getString()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)Component.m_237115_((String)"command.radioactive.amount").getString(), (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> RadiationCommands.setRadiation((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), DoubleArgumentType.getDouble((CommandContext)context, (String)Component.m_237115_((String)"command.radioactive.amount").getString())))).then(Commands.m_82129_((String)Component.m_237115_((String)"command.radioactive.targets").getString(), (ArgumentType)EntityArgument.m_91470_()).executes(context -> RadiationCommands.setRadiation((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)Component.m_237115_((String)"command.radioactive.targets").getString()), DoubleArgumentType.getDouble((CommandContext)context, (String)Component.m_237115_((String)"command.radioactive.amount").getString()))))))).then(Commands.m_82127_((String)Component.m_237115_((String)"command.radioactive.add").getString()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)Component.m_237115_((String)"command.radioactive.amount").getString(), (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> RadiationCommands.addRadiation((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), DoubleArgumentType.getDouble((CommandContext)context, (String)Component.m_237115_((String)"command.radioactive.amount").getString())))).then(Commands.m_82129_((String)Component.m_237115_((String)"command.radioactive.targets").getString(), (ArgumentType)EntityArgument.m_91470_()).executes(context -> RadiationCommands.addRadiation((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)Component.m_237115_((String)"command.radioactive.targets").getString()), DoubleArgumentType.getDouble((CommandContext)context, (String)Component.m_237115_((String)"command.radioactive.amount").getString()))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)Component.m_237115_((String)"command.radioactive.get").getString()).executes(context -> RadiationCommands.getRadiation((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)Component.m_237115_((String)"command.radioactive.targets").getString(), (ArgumentType)EntityArgument.m_91470_()).executes(context -> RadiationCommands.getRadiation((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)Component.m_237115_((String)"command.radioactive.targets").getString()))))))).then(Commands.m_82127_((String)Component.m_237115_((String)"command.radioactive.clear").getString()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            RadiationCommands.clearRadiation((Player)player);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.radioactive.clear.success", (Object[])new Object[]{player.m_7755_().getString()}), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)Component.m_237115_((String)"command.radioactive.tick").getString()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            return RadiationCommands.tickRadiation((CommandSourceStack)context.getSource(), Collections.singleton(player));
        })).then(Commands.m_82129_((String)Component.m_237115_((String)"command.radioactive.targets").getString(), (ArgumentType)EntityArgument.m_91470_()).executes(context -> RadiationCommands.tickRadiation((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)Component.m_237115_((String)"command.radioactive.targets").getString()))))));
    }

    private static int setRadiation(CommandSourceStack source, Collection<ServerPlayer> targets, double amount) {
        for (Player player : targets) {
            player.getCapability(RadiationProvider.RADIATION).ifPresent(cap -> cap.setRadiation((float)amount));
            source.m_288197_(() -> Component.m_237110_((String)"command.radioactive.set.success", (Object[])new Object[]{player.m_7755_().getString(), String.format("%.2f", amount)}), true);
        }
        return targets.size();
    }

    private static int addRadiation(CommandSourceStack source, Collection<ServerPlayer> targets, double amount) {
        for (Player player : targets) {
            float currentRadiation = player.getCapability(RadiationProvider.RADIATION).map(IRadiationCapability::getRadiation).orElse(Float.valueOf(0.0f)).floatValue();
            float newRadiation = currentRadiation + (float)amount;
            player.getCapability(RadiationProvider.RADIATION).ifPresent(cap -> {
                cap.setExposureRate(newRadiation);
                source.m_288197_(() -> Component.m_237110_((String)"command.radioactive.add.success", (Object[])new Object[]{String.format("%.2f", amount), player.m_7755_().getString(), String.format("%.2f", Float.valueOf(newRadiation))}), true);
            });
        }
        return targets.size();
    }

    private static int getRadiation(CommandSourceStack source, Collection<ServerPlayer> targets) {
        for (Player player : targets) {
            String decayInfo = RadiationHelper.getRadiationDecayInfo((LivingEntity)player);
            source.m_288197_(() -> Component.m_237110_((String)"command.radioactive.get.success", (Object[])new Object[]{player.m_7755_().getString(), decayInfo}), true);
        }
        return targets.size();
    }

    private static void clearRadiation(Player player) {
        RadiationHelper.setRadiation((LivingEntity)player, 0.0f);
        RadiationHelper.setRadiationRate((LivingEntity)player, 0.0f);
    }

    private static int tickRadiation(CommandSourceStack source, Collection<ServerPlayer> targets) {
        for (Player player : targets) {
            RadiationHelper.tickRadiationCapability((LivingEntity)player);
            String decayInfo = RadiationHelper.getRadiationDecayInfo((LivingEntity)player);
            source.m_288197_(() -> Component.m_237110_((String)"command.radioactive.tick.success", (Object[])new Object[]{player.m_7755_().getString(), decayInfo}), true);
        }
        return targets.size();
    }
}

