/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.config;

import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.config.StackingStrategy;
import java.util.Arrays;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RadioactiveCommonConfigs {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.DoubleValue MAX_RADIATION;
    public static final ForgeConfigSpec.BooleanValue PERSIST_RADIATION_ON_DEATH;
    public static final ForgeConfigSpec.BooleanValue ENABLE_GEIGER_SOUNDS;
    public static final ForgeConfigSpec.DoubleValue GEIGER_SOUND_VOLUME;
    public static final ForgeConfigSpec.DoubleValue MOB_RADIATION_RADIUS;
    public static final ForgeConfigSpec.DoubleValue ITEM_ENTITY_RADIATION_RADIUS;
    public static final ForgeConfigSpec.DoubleValue ENVIRONMENTAL_SCAN_RADIUS;
    public static final ForgeConfigSpec.BooleanValue SUN_RADIATION;
    public static final ForgeConfigSpec.DoubleValue SUN_RADIATION_PEAK_RATE;
    public static final ForgeConfigSpec.DoubleValue DISTANCE_RADIATION_THRESHOLD;
    public static final ForgeConfigSpec.DoubleValue RADIATION_PER_BLOCK_DISTANCE;
    public static final ForgeConfigSpec.DoubleValue FOG_RADIATION_AMOUNT;
    public static final ForgeConfigSpec.BooleanValue STACK_STRUCTURE_RADIATION;
    public static final ForgeConfigSpec.BooleanValue HEIGHT_RADIATION_ENABLED;
    public static final ForgeConfigSpec.IntValue HEIGHT_RADIATION_SAFE_ALTITUDE;
    public static final ForgeConfigSpec.DoubleValue HEIGHT_RADIATION_PER_BLOCK;
    public static final ForgeConfigSpec.BooleanValue ENABLE_RADIATION_DECAY;
    public static final ForgeConfigSpec.DoubleValue RADIATION_DECAY_RATE;
    public static final ForgeConfigSpec.IntValue MOB_RADIATION_CACHE_INTERVAL;
    public static final ForgeConfigSpec.DoubleValue STOCHASTIC_VALIDATION_PROBABILITY;
    public static final ForgeConfigSpec.IntValue PLAYER_SCAN_RADIUS_CHUNKS;
    public static final ForgeConfigSpec.DoubleValue MINIMUM_DECAY_THRESHOLD;
    public static final ForgeConfigSpec.DoubleValue HIGH_RADIATION_DECAY_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue LOW_RADIATION_DECAY_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue DECAY_BOOST_THRESHOLD;
    public static final ForgeConfigSpec.DoubleValue DECAY_REDUCTION_THRESHOLD;
    public static final ForgeConfigSpec.DoubleValue WOOZY_SPEED_MODIFIER;
    public static final ForgeConfigSpec.DoubleValue WOOZY_OFFSET_MAGNITUDE;
    public static final ForgeConfigSpec.DoubleValue WOOZY_CAMERA_WOBBLE;
    public static final ForgeConfigSpec.DoubleValue DEATH_RINGING_VOLUME;
    public static final ForgeConfigSpec.IntValue ANTI_RAD_MAX_LEVEL;
    public static final ForgeConfigSpec.BooleanValue ANTI_RAD_IS_TREASURE;
    public static final ForgeConfigSpec.DoubleValue ANTI_RAD_REDUCTION_PER_LEVEL;
    public static final ForgeConfigSpec.DoubleValue TIER_1_RADIATION_REDUCTION;
    public static final ForgeConfigSpec.DoubleValue TIER_2_RADIATION_REDUCTION;
    public static final ForgeConfigSpec.DoubleValue TIER_3_RADIATION_REDUCTION;
    public static final ForgeConfigSpec.IntValue FLUSHING_AMOUNT_PER_LEVEL;
    public static final ForgeConfigSpec.IntValue RAD_X_CAP_AMOUNT;
    public static final ForgeConfigSpec.DoubleValue TONGS_INVENTORY_RADIATION_REDUCTION;
    public static final ForgeConfigSpec.BooleanValue TONGS_HAVE_DURABILITY;
    public static final ForgeConfigSpec.IntValue TONGS_MAX_DAMAGE;
    public static final ForgeConfigSpec.DoubleValue TONGS_DAMAGE_CHANCE;
    public static final ForgeConfigSpec.EnumValue<StackingStrategy> PROTECTION_STACKING_STRATEGY;
    public static final ForgeConfigSpec.DoubleValue FOG_RADIATION_REDUCTION;

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            RadioactiveCommonConfigs.validateConfigs();
            Radioactive.LOGGER.info("Radioactive configs reloaded");
        }
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            RadioactiveCommonConfigs.validateConfigs();
            Radioactive.LOGGER.info("Radioactive configs loaded");
        }
    }

    private static void validateConfigs() {
    }

    public static float clampRadiation(float radiation) {
        return Math.min(Math.max(0.0f, radiation), ((Double)MAX_RADIATION.get()).floatValue());
    }

    static {
        BUILDER.push("Radioactive Mod Configuration");
        BUILDER.comment(new String[]{"General Settings", "Core mod behavior and limits"}).push("general");
        MAX_RADIATION = BUILDER.comment(new String[]{"Maximum radiation level a player can accumulate (in rads)", "Higher values allow more extreme radiation poisoning"}).defineInRange("maxRadiation", 1200.0, 0.0, 10000.0);
        PERSIST_RADIATION_ON_DEATH = BUILDER.comment(new String[]{"Whether radiation levels persist after player death", "If false, radiation is cleared on death (easier gameplay)"}).define("persistRadiationOnDeath", false);
        BUILDER.pop();
        BUILDER.comment(new String[]{"User Interface Settings", "Audio and visual feedback options"}).push("interface");
        ENABLE_GEIGER_SOUNDS = BUILDER.comment(new String[]{"Enable geiger counter clicking sounds", "Provides audio feedback for radiation levels"}).define("enableGeigerSounds", true);
        GEIGER_SOUND_VOLUME = BUILDER.comment("Volume of geiger counter sounds (0.0 = silent, 1.0 = full volume)").defineInRange("geigerSoundVolume", 0.4, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.comment(new String[]{"Radiation Sources Configuration", "Settings for various sources of radiation exposure"}).push("sources");
        ENVIRONMENTAL_SCAN_RADIUS = BUILDER.comment(new String[]{"Radius (in blocks) for scanning environmental radiation sources", "Larger values may impact performance but provide more accurate radiation"}).defineInRange("environmentalScanRadius", 64.0, 0.0, 256.0);
        STACK_STRUCTURE_RADIATION = BUILDER.comment(new String[]{"Whether radiation from multiple structures combines", "If false, only the highest structure radiation applies"}).define("stackStructureRadiation", true);
        MOB_RADIATION_RADIUS = BUILDER.comment(new String[]{"Detection radius (in blocks) for radioactive mobs", "How close you must be to receive radiation from creatures"}).defineInRange("mobRadiationRadius", 5.0, 0.0, 50.0);
        ITEM_ENTITY_RADIATION_RADIUS = BUILDER.comment(new String[]{"Detection radius (in blocks) for dropped radioactive items", "How close you must be to receive radiation from items on the ground"}).defineInRange("itemEntityRadiationRadius", 5.0, 0.0, 20.0);
        SUN_RADIATION = BUILDER.comment(new String[]{"Enable radiation exposure from direct sunlight", "Simulates solar radiation effects (experimental feature)"}).define("sunRadiation", false);
        SUN_RADIATION_PEAK_RATE = BUILDER.comment("Maximum radiation per second from sun exposure (at noon)").defineInRange("sunRadiationPeakRate", 0.5, 0.0, 50.0);
        FOG_RADIATION_AMOUNT = BUILDER.comment("Radiation per second from radioactive fog effect").defineInRange("fogRadiationAmount", 5.0, 0.0, 100.0);
        DISTANCE_RADIATION_THRESHOLD = BUILDER.comment(new String[]{"Distance from world spawn (in blocks) where distance radiation begins", "Set to very high value to effectively disable this feature"}).defineInRange("distanceRadiationThreshold", 10000.0, 0.0, 100000.0);
        RADIATION_PER_BLOCK_DISTANCE = BUILDER.comment(new String[]{"Additional radiation per block beyond the distance threshold", "Creates 'wasteland' effect far from spawn"}).defineInRange("radiationPerBlockDistance", (double)0.005f, 0.0, 1.0);
        HEIGHT_RADIATION_ENABLED = BUILDER.comment(new String[]{"Enable radiation exposure based on Y-level (altitude).", "Can be used to create irradiated lower or upper layers of the world."}).define("heightRadiationEnabled", false);
        HEIGHT_RADIATION_SAFE_ALTITUDE = BUILDER.comment(new String[]{"The Y-level that is considered 'safe'.", "Radiation will be applied for each block *below* this altitude."}).defineInRange("heightRadiationSafeAltitude", 64, -64, 320);
        HEIGHT_RADIATION_PER_BLOCK = BUILDER.comment(new String[]{"Amount of radiation to apply per block below the safe altitude.", "This value is multiplied by the distance below the safe altitude."}).defineInRange("heightRadiationPerBlock", 0.01, 0.0, 10.0);
        BUILDER.pop();
        BUILDER.comment(new String[]{"Radiation Decay & Processing", "How radiation levels change over time and advanced decay mechanics"}).push("decay");
        ENABLE_RADIATION_DECAY = BUILDER.comment(new String[]{"Enable natural radiation decay over time", "If disabled, radiation will only decrease through medicine/effects"}).define("enableRadiationDecay", true);
        RADIATION_DECAY_RATE = BUILDER.comment(new String[]{"Base radiation decay rate (rads per second)", "Higher values = faster recovery from radiation"}).defineInRange("radiationDecayRate", 5.0, 0.0, 100.0);
        MINIMUM_DECAY_THRESHOLD = BUILDER.comment(new String[]{"Minimum radiation level where natural decay stops", "Prevents infinite tiny decrements, set to 0 to disable"}).defineInRange("minimumDecayThreshold", 0.1, 0.0, 10.0);
        HIGH_RADIATION_DECAY_MULTIPLIER = BUILDER.comment(new String[]{"Decay rate multiplier for high radiation levels", "Makes severe radiation poisoning clear faster (more forgiving)"}).defineInRange("highRadiationDecayMultiplier", 1.5, 0.1, 5.0);
        DECAY_BOOST_THRESHOLD = BUILDER.comment(new String[]{"Radiation level (in rads) above which high decay multiplier applies", "Severe radiation above this level decays faster"}).defineInRange("decayBoostThreshold", 300.0, 0.0, 1200.0);
        LOW_RADIATION_DECAY_MULTIPLIER = BUILDER.comment(new String[]{"Decay rate multiplier for low radiation levels", "Makes light radiation linger longer (more realistic)"}).defineInRange("lowRadiationDecayMultiplier", 0.5, 0.1, 2.0);
        DECAY_REDUCTION_THRESHOLD = BUILDER.comment(new String[]{"Radiation level (in rads) below which low decay multiplier applies", "Light radiation below this level decays slower"}).defineInRange("decayReductionThreshold", 50.0, 0.0, 200.0);
        BUILDER.pop();
        BUILDER.comment(new String[]{"Radiation Effects", "Visual and gameplay effects caused by radiation exposure"}).push("effects");
        WOOZY_SPEED_MODIFIER = BUILDER.comment(new String[]{"Movement speed modifier for radiation sickness effect", "Negative values slow the player down when irradiated"}).defineInRange("woozySpeedModifier", -0.05, -1.0, 0.0);
        WOOZY_OFFSET_MAGNITUDE = BUILDER.comment(new String[]{"Random movement deviation intensity during radiation sickness", "Higher values make movement more unpredictable"}).defineInRange("woozyOffsetMagnitude", 0.08, 0.0, 1.0);
        WOOZY_CAMERA_WOBBLE = BUILDER.comment(new String[]{"Camera shake intensity during severe radiation exposure", "Set to 0 to disable camera effects"}).defineInRange("woozyCameraWobble", 5.0, 0.0, 50.0);
        DEATH_RINGING_VOLUME = BUILDER.comment(new String[]{"Volume of the death ringing sound effect during fatal radiation", "Plays when radiation reaches critical levels"}).defineInRange("deathRingingVolume", 1.0, 0.0, 2.0);
        BUILDER.pop();
        BUILDER.comment(new String[]{"Protection & Medicine", "Radiation protection, armor, medicine, and treatment options"}).push("protection");
        PROTECTION_STACKING_STRATEGY = BUILDER.comment(new String[]{"How multiple radiation protection sources combine:", "ADDITIVE: 10% + 20% = 30% total reduction", "MULTIPLICATIVE: 10% and 20% = 28% total reduction (more realistic)"}).defineEnum("protectionStackingStrategy", (Enum)StackingStrategy.ADDITIVE, Arrays.asList(StackingStrategy.values()));
        FOG_RADIATION_REDUCTION = BUILDER.comment(new String[]{"Reduction in protection effectiveness when in radioactive fog", "0.1 = 10% less effective, simulating fog penetration"}).defineInRange("fogRadiationReduction", (double)0.1f, 0.0, 1.0);
        ANTI_RAD_MAX_LEVEL = BUILDER.comment(new String[]{"Maximum level for the Anti-Radiation enchantment", "Higher levels provide more protection"}).defineInRange("antiRadMaxLevel", 3, 1, 10);
        ANTI_RAD_IS_TREASURE = BUILDER.comment(new String[]{"Whether Anti-Radiation enchantment is treasure-only", "If true, cannot be obtained through normal enchanting"}).define("antiRadIsTreasure", true);
        ANTI_RAD_REDUCTION_PER_LEVEL = BUILDER.comment(new String[]{"Radiation protection per enchantment level (as decimal)", "0.2 = 20% protection per level"}).defineInRange("antiRadReductionPerLevel", 0.2, 0.0, 1.0);
        TIER_1_RADIATION_REDUCTION = BUILDER.comment(new String[]{"Radiation protection for Tier 1 armor (basic protection)", "Percentage of radiation blocked (0.12 = 12% reduction)"}).defineInRange("tier1RadiationReduction", 0.12, 0.0, 1.0);
        TIER_2_RADIATION_REDUCTION = BUILDER.comment(new String[]{"Radiation protection for Tier 2 armor (improved protection)", "Percentage of radiation blocked (0.16 = 16% reduction)"}).defineInRange("tier2RadiationReduction", 0.16, 0.0, 1.0);
        TIER_3_RADIATION_REDUCTION = BUILDER.comment(new String[]{"Radiation protection for Tier 3 armor (advanced protection)", "Percentage of radiation blocked (0.20 = 20% reduction)"}).defineInRange("tier3RadiationReduction", 0.2, 0.0, 1.0);
        FLUSHING_AMOUNT_PER_LEVEL = BUILDER.comment(new String[]{"Radiation removed per level of Radiation Flushing effect", "Higher values make medicine more effective"}).defineInRange("flushingAmountPerLevel", 10, 0, 100);
        RAD_X_CAP_AMOUNT = BUILDER.comment(new String[]{"Maximum safe amplifier level for Rad-X resistance effect", "Higher levels may cause negative side effects"}).defineInRange("radXCapAmount", 1, 0, 10);
        TONGS_INVENTORY_RADIATION_REDUCTION = BUILDER.comment(new String[]{"Percentage of inventory radiation reduced by Industrial Tongs", "0.75 = 75% reduction when carrying radioactive items"}).defineInRange("tongsInventoryRadiationReduction", 0.75, 0.0, 1.0);
        TONGS_HAVE_DURABILITY = BUILDER.comment(new String[]{"Whether Industrial Tongs degrade from protecting against radiation", "If false, tongs never break from radiation exposure"}).define("tongsHaveDurability", true);
        TONGS_MAX_DAMAGE = BUILDER.comment(new String[]{"Maximum durability of Industrial Tongs", "Higher values make tongs last longer"}).defineInRange("tongsMaxDamage", 250, 1, 1000);
        TONGS_DAMAGE_CHANCE = BUILDER.comment(new String[]{"Chance per second that tongs take 1 damage per radioactive item stack", "0.1 = 10% chance per second per radioactive stack"}).defineInRange("tongsDamageChance", 0.1, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.comment(new String[]{"Performance & Technical Settings", "Optimization settings that may impact performance"}).push("performance");
        MOB_RADIATION_CACHE_INTERVAL = BUILDER.comment(new String[]{"How often mob radiation is recalculated (in ticks)", "Higher values improve performance but reduce accuracy (20 ticks = 1 second)"}).defineInRange("mobRadiationCacheInterval", 60, 1, 200);
        STOCHASTIC_VALIDATION_PROBABILITY = BUILDER.comment(new String[]{"Probability to validate radiation sources each second (0.0-1.0)", "Lower values improve performance but may allow invalid sources to persist", "Only change if experiencing performance issues"}).defineInRange("stochasticValidationProbability", 0.02, 0.0, 1.0);
        PLAYER_SCAN_RADIUS_CHUNKS = BUILDER.comment("The radius, in chunks, around the player to scan for environmental radiation sources.").defineInRange("playerScanRadiusChunks", 4, 1, 16);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

