/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.entities;

import com.google.common.collect.Sets;
import com.radar.radioactive.common.radiation.RadiationHelper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class RadLightningEntity
extends LightningBolt {
    private static final int START_LIFE = 20;
    private static final double DAMAGE_RADIUS = 3.0;
    private static final double DETECTION_RADIUS = 15.0;
    private final Set<Entity> hitEntities = Sets.newHashSet();
    public long seed;
    private int life;
    private int flashes;
    @Nullable
    private ServerPlayer cause;
    private int blocksSetOnFire;
    private final float damage = 5.0f;

    public RadLightningEntity(EntityType<? extends RadLightningEntity> entity, Level level) {
        super(entity, level);
        this.f_19811_ = true;
        this.life = 2;
        this.seed = this.f_19796_.m_188505_();
        this.flashes = this.f_19796_.m_188503_(3) + 1;
    }

    private static void m_147150_(Level pLevel, BlockPos pPos) {
        BlockState blockstate1;
        BlockPos blockpos;
        BlockState blockstate = pLevel.m_8055_(pPos);
        if (blockstate.m_60713_(Blocks.f_152587_)) {
            blockpos = pPos.m_121945_(((Direction)blockstate.m_61143_((Property)LightningRodBlock.f_52588_)).m_122424_());
            blockstate1 = pLevel.m_8055_(blockpos);
        } else {
            blockpos = pPos;
            blockstate1 = blockstate;
        }
        if (blockstate1.m_60734_() instanceof WeatheringCopper) {
            pLevel.m_46597_(blockpos, WeatheringCopper.m_154906_((BlockState)pLevel.m_8055_(blockpos)));
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
            int i = pLevel.f_46441_.m_188503_(3) + 3;
            for (int j = 0; j < i; ++j) {
                int k = pLevel.f_46441_.m_188503_(8) + 1;
                RadLightningEntity.m_147145_(pLevel, blockpos, blockpos$mutableblockpos, k);
            }
        }
    }

    private static void m_147145_(Level pLevel, BlockPos pPos, BlockPos.MutableBlockPos pMutable, int pSteps) {
        Optional<BlockPos> optional;
        pMutable.m_122190_((Vec3i)pPos);
        for (int i = 0; i < pSteps && !(optional = RadLightningEntity.m_147153_(pLevel, (BlockPos)pMutable)).isEmpty(); ++i) {
            pMutable.m_122190_((Vec3i)optional.get());
        }
    }

    private static Optional<BlockPos> m_147153_(Level pLevel, BlockPos pPos) {
        for (BlockPos blockpos : BlockPos.m_235650_((RandomSource)pLevel.f_46441_, (int)10, (BlockPos)pPos, (int)1)) {
            BlockState blockstate = pLevel.m_8055_(blockpos);
            if (!(blockstate.m_60734_() instanceof WeatheringCopper)) continue;
            WeatheringCopper.m_154899_((BlockState)blockstate).ifPresent(p_147144_ -> pLevel.m_46597_(blockpos, p_147144_));
            pLevel.m_46796_(3002, blockpos, -1);
            return Optional.of(blockpos);
        }
        return Optional.empty();
    }

    public SoundSource m_5720_() {
        return SoundSource.WEATHER;
    }

    @Nullable
    public ServerPlayer m_147158_() {
        return this.cause;
    }

    public void m_20879_(@Nullable ServerPlayer player) {
        this.cause = player;
    }

    private void powerLightning() {
        BlockPos blockpos = this.m_147162_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_152587_)) {
            ((LightningRodBlock)blockstate.m_60734_()).m_153760_(blockstate, this.m_9236_(), blockpos);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.life == 2) {
            if (this.m_9236_().m_5776_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 10000.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f, false);
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12089_, SoundSource.WEATHER, 2.0f, 0.5f + this.f_19796_.m_188501_() * 0.2f, false);
            } else {
                Difficulty difficulty = this.m_9236_().m_46791_();
                if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
                    this.m_20870_(4);
                }
                this.powerLightning();
                RadLightningEntity.m_147150_(this.m_9236_(), this.m_147162_());
                this.m_146850_(GameEvent.f_157772_);
            }
        }
        --this.life;
        if (this.flashes < 0) {
            if (this.flashes == 0) {
                if (this.m_9236_() instanceof ServerLevel) {
                    List list = this.m_9236_().m_6249_((Entity)this, new AABB(this.m_20185_() - 15.0, this.m_20186_() - 15.0, this.m_20189_() - 15.0, this.m_20185_() + 15.0, this.m_20186_() + 6.0 + 15.0, this.m_20189_() + 15.0), entity -> entity.m_6084_() && !this.hitEntities.contains(entity));
                    for (ServerPlayer serverPlayer : ((ServerLevel)this.m_9236_()).m_8795_(player -> player.m_20270_((Entity)this) < 256.0f)) {
                        CriteriaTriggers.f_145089_.m_153391_(serverPlayer, (LightningBolt)this, list);
                    }
                }
                this.m_146870_();
            } else if (this.life < -this.f_19796_.m_188503_(10)) {
                --this.flashes;
                this.life = 1;
                this.seed = this.f_19796_.m_188505_();
                this.m_20870_(0);
            }
        }
        if (this.life >= 0) {
            if (!this.m_9236_().m_5776_()) {
                List list1 = this.m_9236_().m_6249_((Entity)this, new AABB(this.m_20185_() - 3.0, this.m_20186_() - 3.0, this.m_20189_() - 3.0, this.m_20185_() + 3.0, this.m_20186_() + 6.0 + 3.0, this.m_20189_() + 3.0), Entity::m_6084_);
                for (Entity entity2 : list1) {
                    if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity2, (LightningBolt)this)) continue;
                    entity2.m_8038_((ServerLevel)this.m_9236_(), (LightningBolt)this);
                    if (!(entity2 instanceof Player)) continue;
                    RadiationHelper.addRadiation((LivingEntity)((Player)entity2), 99999.0f);
                }
            } else {
                this.m_9236_().m_6580_(2);
            }
        }
    }

    private void m_20870_(int pExtraIgnitions) {
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46131_)) {
            BlockPos blockpos = this.m_20183_();
            BlockState blockstate = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockpos);
            if (this.m_9236_().m_8055_(blockpos).m_60795_() && blockstate.m_60710_((LevelReader)this.m_9236_(), blockpos)) {
                this.m_9236_().m_46597_(blockpos, blockstate);
                ++this.blocksSetOnFire;
            }
            for (int i = 0; i < pExtraIgnitions; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1);
                blockstate = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockpos1);
                if (!this.m_9236_().m_8055_(blockpos1).m_60795_() || !blockstate.m_60710_((LevelReader)this.m_9236_(), blockpos1)) continue;
                this.m_9236_().m_46597_(blockpos1, blockstate);
                ++this.blocksSetOnFire;
            }
        }
    }

    private BlockPos m_147162_() {
        Vec3 vec3 = this.m_20182_();
        return BlockPos.m_274561_((double)vec3.f_82479_, (double)(vec3.f_82480_ - 1.0E-6), (double)vec3.f_82481_);
    }
}

