/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.events;

import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.registry.ModEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="radioactive")
public class PunishmentEvent {
    private static final List<LightningTask> PENDING_TASKS = new ArrayList<LightningTask>();

    public static void scheduleStrikeSequence(ServerPlayer player, int totalStrikes, int delayInTicks) {
        PENDING_TASKS.add(new LightningTask(player.m_20148_(), totalStrikes, delayInTicks));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ListIterator<LightningTask> iterator = PENDING_TASKS.listIterator();
        while (iterator.hasNext()) {
            ServerLevel level;
            LightningTask task = iterator.next();
            --task.ticksUntilNextStrike;
            if (task.ticksUntilNextStrike > 0) continue;
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(task.playerUUID);
            ServerLevel serverLevel = level = player != null ? player.m_284548_() : null;
            if (player != null && level != null) {
                EntityType entityToSpawn = (EntityType)ModEntities.RAD_LIGHTNING.get();
                Entity newEntity = entityToSpawn.m_20615_((Level)level);
                if (newEntity != null) {
                    double z;
                    double y;
                    double x;
                    if (task.strikesRemaining == 1) {
                        Radioactive.LOGGER.info("Executing final strike on player " + player.m_7755_().getString());
                        x = player.m_20185_();
                        y = player.m_20186_();
                        z = player.m_20189_();
                    } else {
                        x = player.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * 6.0;
                        y = player.m_20186_();
                        z = player.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * 6.0;
                    }
                    newEntity.m_6034_(x, y, z);
                    level.m_7967_(newEntity);
                }
                --task.strikesRemaining;
            }
            if (task.strikesRemaining > 0) {
                task.ticksUntilNextStrike = 20 + (level != null ? level.f_46441_.m_188503_(20) : 20);
                continue;
            }
            iterator.remove();
        }
    }

    private static class LightningTask {
        private final UUID playerUUID;
        private int strikesRemaining;
        private int ticksUntilNextStrike;

        public LightningTask(UUID playerUUID, int strikesRemaining, int ticksUntilNextStrike) {
            this.playerUUID = playerUUID;
            this.strikesRemaining = strikesRemaining;
            this.ticksUntilNextStrike = ticksUntilNextStrike;
        }
    }
}

