/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.events;

import com.radar.radioactive.common.radiation.ArmorUpgradeHandler;
import com.radar.radioactive.common.radiation.RadiationHelper;
import com.radar.radioactive.common.radiation.RadiationRegistry;
import com.radar.radioactive.common.registry.ModEnchantments;
import com.radar.radioactive.common.util.RadFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public final class TooltipEvents {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        int antiRadLvl;
        float itemReduction;
        ItemStack stack = event.getItemStack();
        float radiation = TooltipEvents.getStackRadiation(stack);
        if (radiation > 0.0f) {
            TooltipEvents.addRadiationLines(event, stack, radiation);
        }
        if ((itemReduction = ArmorUpgradeHandler.getArmorReduction(stack)) == 0.0f) {
            itemReduction = RadiationRegistry.getArmorReduction(stack);
        }
        if (itemReduction > 0.0f) {
            event.getToolTip().add(Component.m_237113_((String)(Component.m_237115_((String)"tooltip.radioactive.reduction").getString() + ": " + RadFormat.formatPercent(itemReduction) + "%")).m_130940_(ChatFormatting.GREEN));
        }
        if ((antiRadLvl = stack.getEnchantmentLevel((Enchantment)ModEnchantments.ANTI_RADIATION.get())) > 0) {
            float perc = RadiationHelper.getEnchantmentReduction(antiRadLvl);
            event.getToolTip().add(Component.m_237110_((String)"tooltip.radioactive.anti_radiation", (Object[])new Object[]{RadFormat.formatPercent(perc)}));
        }
    }

    private static float getStackRadiation(ItemStack stack) {
        return RadiationRegistry.getItemRadiation(stack) * (float)stack.m_41613_();
    }

    private static void addRadiationLines(ItemTooltipEvent evt, ItemStack stack, float rads) {
        float red;
        Player player = evt.getEntity();
        evt.getToolTip().add(Component.m_237110_((String)"tooltip.radioactive.radiation_level", (Object[])new Object[]{RadFormat.format(rads)}).m_130940_(TooltipEvents.getRadiationColor(rads)));
        if (player != null && (red = TooltipEvents.calculatePlayerReduction(player)) > 0.0f) {
            float after = rads * (1.0f - red);
            evt.getToolTip().add(Component.m_237113_((String)("\u2192 " + RadFormat.format(after) + " ")).m_7220_((Component)Component.m_237115_((String)"tooltip.radioactive.with_protection")).m_130940_(ChatFormatting.GRAY));
        }
        evt.getToolTip().add(Component.m_237113_((String)"\u2622 ").m_7220_((Component)Component.m_237115_((String)"tooltip.radioactive.warning")).m_130940_(ChatFormatting.RED));
    }

    private static float calculatePlayerReduction(Player p) {
        float sum = 0.0f;
        for (ItemStack armour : p.m_6168_()) {
            int lvl = armour.getEnchantmentLevel((Enchantment)ModEnchantments.ANTI_RADIATION.get());
            if (lvl <= 0) continue;
            sum += RadiationHelper.getEnchantmentReduction(lvl);
        }
        return Math.min(sum, 1.0f);
    }

    private static ChatFormatting getRadiationColor(float r) {
        return r >= 75.0f ? ChatFormatting.DARK_RED : (r >= 50.0f ? ChatFormatting.RED : (r >= 25.0f ? ChatFormatting.GOLD : ChatFormatting.YELLOW));
    }
}

