/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.items;

import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.items.ItemWithShiftTooltip;
import com.radar.radioactive.common.network.NetworkHandler;
import com.radar.radioactive.common.network.packets.S2CGeigerUpdatePacket;
import com.radar.radioactive.common.radiation.RadiationHelper;
import com.radar.radioactive.common.registry.ModSounds;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ItemGeigerCounter
extends ItemWithShiftTooltip
implements ICurioItem {
    private static final int SOUND_TICK_INTERVAL = 5;
    private static final int RADIATION_LOW = 1;
    private static final int RADIATION_MODERATE = 5;
    private static final int RADIATION_HIGH = 20;
    private static final int RADIATION_SEVERE = 40;
    private static final int RADIATION_EXTREME = 80;
    private static final String KEY_LAST_READING = "last_reading";
    private static final String KEY_LAST_SHIELDING = "last_shielding";
    private static final DecimalFormat RADIATION_FORMAT = new DecimalFormat("0.##");
    private static final NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    private int soundTickCounter = 0;

    public ItemGeigerCounter(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean isHeld = player.m_21205_() == stack || player.m_21206_() == stack;
        boolean geigerInHotbar = false;
        for (int i = 0; i < 9; ++i) {
            ItemStack items = player.m_150109_().m_8020_(i);
            if (!(items.m_41720_() instanceof ItemGeigerCounter)) continue;
            geigerInHotbar = true;
            break;
        }
        if (!isHeld && !geigerInHotbar) {
            return;
        }
        this.doGeigerCounter(stack, player, level);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level level = player.m_9236_();
        this.doGeigerCounter(stack, player, level);
    }

    private void doGeigerCounter(ItemStack stack, Player player, Level level) {
        if (!level.m_5776_()) {
            float storedRadiation = RadiationHelper.getRadiation((LivingEntity)player);
            float exposureRate = RadiationHelper.getRadiationRate((LivingEntity)player);
            float shielding = RadiationHelper.getRadiationResistance((LivingEntity)player);
            float effectiveRate = exposureRate * (1.0f - shielding);
            CompoundTag tag = stack.m_41784_();
            tag.m_128350_(KEY_LAST_READING, effectiveRate);
            tag.m_128350_(KEY_LAST_SHIELDING, shielding);
            if (((Boolean)RadioactiveCommonConfigs.ENABLE_GEIGER_SOUNDS.get()).booleanValue()) {
                ++this.soundTickCounter;
                if (this.soundTickCounter >= 5) {
                    this.playGeigerSound(level, player);
                    this.soundTickCounter = 0;
                }
            }
            S2CGeigerUpdatePacket packet = new S2CGeigerUpdatePacket(true, storedRadiation, exposureRate, effectiveRate);
            NetworkHandler.sendToPlayer(packet, (ServerPlayer)player);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    private void playGeigerSound(Level level, Player player) {
        float exposureRate = RadiationHelper.getRadiationRate((LivingEntity)player);
        float effectiveRate = exposureRate * (1.0f - RadiationHelper.getRadiationResistance((LivingEntity)player));
        if (!level.m_5776_()) {
            if (effectiveRate <= 0.0f && level.m_213780_().m_188503_(50) == 0) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.GEIGER_CLICK.get(), SoundSource.PLAYERS, ((Double)RadioactiveCommonConfigs.GEIGER_SOUND_VOLUME.get()).floatValue(), 1.0f);
                return;
            }
            if (effectiveRate > 0.1f) {
                int soundLevel = effectiveRate < 1.0f ? 1 : (effectiveRate < 5.0f ? 2 : (effectiveRate < 20.0f ? 3 : (effectiveRate < 40.0f ? 4 : (effectiveRate < 80.0f ? 5 : 6))));
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.getGeigerSound(soundLevel), SoundSource.PLAYERS, ((Double)RadioactiveCommonConfigs.GEIGER_SOUND_VOLUME.get()).floatValue(), 1.0f);
            }
        }
    }

    @Override
    protected void addBaseTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        float lastRadiationReading = 0.0f;
        float lastShielding = 0.0f;
        if (tag != null && tag.m_128441_(KEY_LAST_READING)) {
            lastRadiationReading = tag.m_128457_(KEY_LAST_READING);
        }
        if (tag != null && tag.m_128441_(KEY_LAST_SHIELDING)) {
            lastShielding = tag.m_128457_(KEY_LAST_SHIELDING);
        }
        ChatFormatting radiationColor = this.getRadiationColor(lastRadiationReading);
        tooltip.add((Component)Component.m_237110_((String)"tooltip.radioactive.geiger.reading", (Object[])new Object[]{RADIATION_FORMAT.format(lastRadiationReading)}).m_130940_(radiationColor));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.radioactive.geiger.shielding", (Object[])new Object[]{percentFormatter.format(lastShielding)}).m_130940_(ChatFormatting.BLUE));
    }

    @Override
    protected void addShiftTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.geiger.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.geiger.usage").m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.geiger.levels").m_130940_(ChatFormatting.WHITE));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237115_((String)"tooltip.radioactive.geiger.safe")));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237115_((String)"tooltip.radioactive.geiger.caution")));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)"tooltip.radioactive.geiger.danger")));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 ").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237115_((String)"tooltip.radioactive.geiger.severe")));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237115_((String)"tooltip.radioactive.geiger.extreme")));
    }

    private ChatFormatting getRadiationColor(float radiationLevel) {
        if (radiationLevel <= 0.1f) {
            return ChatFormatting.GREEN;
        }
        if (radiationLevel < 1.0f) {
            return ChatFormatting.GREEN;
        }
        if (radiationLevel < 5.0f) {
            return ChatFormatting.YELLOW;
        }
        if (radiationLevel < 20.0f) {
            return ChatFormatting.GOLD;
        }
        if (radiationLevel < 40.0f) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.DARK_RED;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_41720_().equals(newStack.m_41720_());
    }
}

