/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.items;

import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.items.ItemWithShiftTooltip;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemIndustrialTongs
extends ItemWithShiftTooltip {
    public ItemIndustrialTongs(Item.Properties properties) {
        super(properties);
    }

    public boolean isDamageable(ItemStack stack) {
        return (Boolean)RadioactiveCommonConfigs.TONGS_HAVE_DURABILITY.get();
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)RadioactiveCommonConfigs.TONGS_MAX_DAMAGE.get();
    }

    public boolean isRepairable(ItemStack stack) {
        return true;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repairWith) {
        return repairWith.m_150930_(Items.f_42574_);
    }

    @Override
    protected void addBaseTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        double reduction = (Double)RadioactiveCommonConfigs.TONGS_INVENTORY_RADIATION_REDUCTION.get();
        tooltip.add((Component)Component.m_237110_((String)"tooltip.radioactive.industrial_tongs.reduction", (Object[])new Object[]{String.format("%.0f%%", reduction * 100.0)}).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    protected void addShiftTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        double reduction = (Double)RadioactiveCommonConfigs.TONGS_INVENTORY_RADIATION_REDUCTION.get();
        if (reduction >= 1.0) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.industrial_tongs.desc.full").m_130940_(ChatFormatting.GREEN));
        } else if (reduction >= 0.75) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.industrial_tongs.desc.high").m_130940_(ChatFormatting.GREEN));
        } else if (reduction >= 0.5) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.industrial_tongs.desc.medium").m_130940_(ChatFormatting.YELLOW));
        } else if (reduction > 0.0) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.industrial_tongs.desc.low").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.industrial_tongs.desc.none").m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (((Boolean)RadioactiveCommonConfigs.TONGS_HAVE_DURABILITY.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.industrial_tongs.durability_warning").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
        }
    }
}

