/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.items;

import com.radar.radioactive.client.model.ModArmPoses;
import com.radar.radioactive.client.renderer.item.RendererRadaway;
import com.radar.radioactive.common.radiation.RadiationHelper;
import com.radar.radioactive.common.registry.ModEffects;
import com.radar.radioactive.common.registry.ModSounds;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ItemRadaway
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final DecimalFormat RADIATION_FORMAT = new DecimalFormat("0.#");
    private final float radiationReduction;
    private final int useDuration;
    private final String tier;

    public ItemRadaway(Item.Properties properties, float radiationReduction, int useDuration, String tier) {
        super(properties);
        this.radiationReduction = radiationReduction;
        this.useDuration = useDuration;
        this.tier = tier;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        if (!level.f_46443_ && entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            float currentRadiation = RadiationHelper.getRadiation((LivingEntity)player);
            double newRadiation = Math.max(0.0f, currentRadiation - this.radiationReduction);
            RadiationHelper.addRadiation((LivingEntity)player, -this.radiationReduction);
            if (newRadiation <= 0.0) {
                player.m_21195_((MobEffect)ModEffects.RADIATION_POISONING.get());
            }
            int nauseaDuration = switch (this.tier) {
                case "basic" -> 200;
                case "advanced" -> 100;
                case "ultimate" -> 60;
                default -> 200;
            };
            level.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.RADAWAY_USE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, nauseaDuration));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
        }
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.radioactive.radaway_reduction", (Object[])new Object[]{RADIATION_FORMAT.format(this.radiationReduction)}).m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel.ArmPose getArmPose(LivingEntity entity, InteractionHand hand, ItemStack stack) {
                if (entity.m_21211_() == stack && entity.m_21212_() > 0) {
                    return ModArmPoses.INJECT_BLOOD;
                }
                return super.getArmPose(entity, hand, stack);
            }
        });
        consumer.accept(new IClientItemExtensions(){
            private RendererRadaway renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new RendererRadaway();
                }
                return this.renderer;
            }
        });
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return this.useDuration;
    }

    public boolean m_5812_(ItemStack stack) {
        return this.tier.equals("ultimate");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public String getTier() {
        return this.tier;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

