/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.network;

import com.radar.radioactive.client.handler.ClientPacketHandler;
import com.radar.radioactive.common.network.packets.S2CGeigerBrokenPacket;
import com.radar.radioactive.common.network.packets.S2CGeigerUpdatePacket;
import com.radar.radioactive.common.network.packets.S2CImpendingDeathPacket;
import com.radar.radioactive.common.network.packets.S2CRadioactiveFogPacket;
import com.radar.radioactive.common.network.packets.S2CSyncRadiationPacket;
import com.radar.radioactive.common.network.packets.S2CUpdateSafeChunkPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("radioactive", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    public static void register() {
        INSTANCE.registerMessage(NetworkHandler.id(), S2CImpendingDeathPacket.class, S2CImpendingDeathPacket::encode, S2CImpendingDeathPacket::decode, S2CImpendingDeathPacket::handle);
        INSTANCE.registerMessage(NetworkHandler.id(), S2CGeigerUpdatePacket.class, S2CGeigerUpdatePacket::encode, S2CGeigerUpdatePacket::decode, S2CGeigerUpdatePacket::handle);
        INSTANCE.registerMessage(NetworkHandler.id(), S2CGeigerBrokenPacket.class, S2CGeigerBrokenPacket::encode, S2CGeigerBrokenPacket::decode, S2CGeigerBrokenPacket::handle);
        INSTANCE.registerMessage(NetworkHandler.id(), S2CRadioactiveFogPacket.class, S2CRadioactiveFogPacket::encode, S2CRadioactiveFogPacket::decode, S2CRadioactiveFogPacket::handle);
        INSTANCE.registerMessage(NetworkHandler.id(), S2CUpdateSafeChunkPacket.class, S2CUpdateSafeChunkPacket::encode, S2CUpdateSafeChunkPacket::decode, ClientPacketHandler::handleSafeChunkUpdate);
        INSTANCE.registerMessage(NetworkHandler.id(), S2CSyncRadiationPacket.class, S2CSyncRadiationPacket::encode, S2CSyncRadiationPacket::decode, S2CSyncRadiationPacket::handle);
    }

    private static int id() {
        return packetId++;
    }

    public static void sendToPlayer(S2CImpendingDeathPacket packet, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendToPlayer(S2CGeigerUpdatePacket packet, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToAll(MSG message) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }

    public static void sendToAll(S2CRadioactiveFogPacket packet) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public static void sendSafeChunkPacketToClients(Level level, ChunkPos chunkPos, boolean safe) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        S2CUpdateSafeChunkPacket packet = new S2CUpdateSafeChunkPacket(chunkPos, safe);
        for (ServerPlayer player : serverLevel.m_6907_()) {
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
        }
    }
}

