/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.network.packets;

import com.radar.radioactive.client.sound.SoundMuteHandler;
import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.registry.ModSounds;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.network.NetworkEvent;

public class S2CImpendingDeathPacket {
    private final boolean activate;
    private final float volume;

    public S2CImpendingDeathPacket(boolean activate, float volume) {
        this.activate = activate;
        this.volume = volume;
    }

    public S2CImpendingDeathPacket(boolean activate) {
        this.activate = activate;
        this.volume = 1.0f;
    }

    public static void encode(S2CImpendingDeathPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.activate);
        buf.writeFloat(packet.volume);
    }

    public static S2CImpendingDeathPacket decode(FriendlyByteBuf buf) {
        return new S2CImpendingDeathPacket(buf.readBoolean(), buf.readFloat());
    }

    public static void handle(S2CImpendingDeathPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Radioactive.LOGGER.debug("Handling ImpendingDeath packet - activate: {}", (Object)packet.activate);
            Minecraft mc = Minecraft.m_91087_();
            if (packet.activate) {
                mc.f_91074_.m_5496_((SoundEvent)ModSounds.RINGING.get(), packet.volume, 1.0f);
                SoundMuteHandler.setEffectActive(true);
            } else {
                SoundMuteHandler.setEffectActive(false);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

