/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.network.packets;

import com.radar.radioactive.client.events.RadioactiveFogHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class S2CRadioactiveFogPacket {
    private final boolean active;

    public S2CRadioactiveFogPacket(boolean active) {
        this.active = active;
    }

    public static void encode(S2CRadioactiveFogPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.active);
    }

    public static S2CRadioactiveFogPacket decode(FriendlyByteBuf buf) {
        boolean active = buf.readBoolean();
        return new S2CRadioactiveFogPacket(active);
    }

    public static void handle(S2CRadioactiveFogPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> RadioactiveFogHandler.setFogActive(packet.isActive()));
        context.get().setPacketHandled(true);
    }

    public boolean isActive() {
        return this.active;
    }
}

