/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.network.packets;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;

public class S2CUpdateSafeChunkPacket {
    private final int chunkX;
    private final int chunkZ;
    private final boolean isSafe;

    public S2CUpdateSafeChunkPacket(ChunkPos chunkPos, boolean isSafe) {
        this.chunkX = chunkPos.f_45578_;
        this.chunkZ = chunkPos.f_45579_;
        this.isSafe = isSafe;
    }

    public S2CUpdateSafeChunkPacket(FriendlyByteBuf buf) {
        this.chunkX = buf.readInt();
        this.chunkZ = buf.readInt();
        this.isSafe = buf.readBoolean();
    }

    public static void encode(S2CUpdateSafeChunkPacket packet, FriendlyByteBuf buf) {
        packet.toBytes(buf);
    }

    public static S2CUpdateSafeChunkPacket decode(FriendlyByteBuf buf) {
        return new S2CUpdateSafeChunkPacket(buf);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.chunkX);
        buf.writeInt(this.chunkZ);
        buf.writeBoolean(this.isSafe);
    }

    public ChunkPos getChunkPos() {
        return new ChunkPos(this.chunkX, this.chunkZ);
    }

    public boolean isSafe() {
        return this.isSafe;
    }
}

