/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation;

import com.davidmoten.rtree.geometry.Rectangle;
import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.radiation.RadiationHelper;
import com.radar.radioactive.common.radiation.RadiationRegistry;
import com.radar.radioactive.common.radiation.capabilities.IRadiationCapability;
import com.radar.radioactive.common.radiation.capabilities.RadiationProvider;
import com.radar.radioactive.common.radiation.level.RadiationAttributeModifier;
import com.radar.radioactive.common.radiation.level.RadiationDamage;
import com.radar.radioactive.common.radiation.level.RadiationLevel;
import com.radar.radioactive.common.radiation.level.RadiationLevelEffect;
import com.radar.radioactive.common.radiation.level.RadiationLevelRegistry;
import com.radar.radioactive.common.radiation.sources.BiomeRadiationProvider;
import com.radar.radioactive.common.radiation.sources.BlockRadiationProvider;
import com.radar.radioactive.common.radiation.sources.DimensionRadiationProvider;
import com.radar.radioactive.common.radiation.sources.EntityRadiationProvider;
import com.radar.radioactive.common.radiation.sources.HeightRadiationProvider;
import com.radar.radioactive.common.radiation.sources.IRadiationSourceProvider;
import com.radar.radioactive.common.radiation.sources.InventoryRadiationProvider;
import com.radar.radioactive.common.radiation.sources.MiscRadiationProvider;
import com.radar.radioactive.common.radiation.sources.StructureRadiationProvider;
import com.radar.radioactive.common.radiation.spatial.Attenuation;
import com.radar.radioactive.common.radiation.spatial.RadiationRaycast;
import com.radar.radioactive.common.radiation.spatial.RadiationSource;
import com.radar.radioactive.common.registry.ModDamageTypes;
import com.radar.radioactive.common.registry.ModEffects;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class RadiationHandler {
    private static final int TICKS_PER_CHECK = 20;
    private static final List<IRadiationSourceProvider> radiationProviders = List.of(new InventoryRadiationProvider(), new BlockRadiationProvider(), new BiomeRadiationProvider(), new StructureRadiationProvider(), new MiscRadiationProvider(), new EntityRadiationProvider(), new DimensionRadiationProvider(), new HeightRadiationProvider());
    private static final Map<UUID, Set<ResourceLocation>> playerActiveRadiationLevels = new ConcurrentHashMap<UUID, Set<ResourceLocation>>();
    private static final Map<UUID, Map<ResourceLocation, Float>> playerProgressiveDamage = new ConcurrentHashMap<UUID, Map<ResourceLocation, Float>>();

    private RadiationHandler() {
    }

    @SubscribeEvent
    public static void onPlayerTick(LivingEvent.LivingTickEvent e) {
        Player p;
        block6: {
            block5: {
                LivingEntity livingEntity = e.getEntity();
                if (!(livingEntity instanceof Player)) break block5;
                p = (Player)livingEntity;
                if (!p.m_9236_().f_46443_ && !p.m_5833_() && p.m_6084_()) break block6;
            }
            return;
        }
        if (p.f_19797_ % 20 != 0) {
            return;
        }
        RadiationHelper.updateResistance((LivingEntity)p);
        float totalRadiation = 0.0f;
        for (IRadiationSourceProvider provider : radiationProviders) {
            totalRadiation += provider.getRadiation(p);
        }
        RadiationHelper.setRadiationRate((LivingEntity)p, totalRadiation);
        float effective = totalRadiation * (1.0f - RadiationHelper.getRadiationResistance((LivingEntity)p));
        RadiationHelper.addRadiation((LivingEntity)p, effective);
        p.getCapability(RadiationProvider.RADIATION).ifPresent(IRadiationCapability::tick);
        RadiationHandler.handleRadiationLevelEffects(p);
    }

    private static void handleRadiationLevelEffects(Player player) {
        Set lastActiveLevels;
        Set<ResourceLocation> newActiveLevels = RadiationHandler.determineActiveLevels(RadiationHelper.getRadiation((LivingEntity)player));
        if (newActiveLevels.equals(lastActiveLevels = (Set)playerActiveRadiationLevels.getOrDefault(player.m_20148_(), new HashSet()))) {
            RadiationHandler.applyContinuousEffects(player, newActiveLevels);
            return;
        }
        RadiationHandler.processLevelTransitions(player, lastActiveLevels, newActiveLevels);
        playerActiveRadiationLevels.put(player.m_20148_(), newActiveLevels);
        RadiationHandler.applyContinuousEffects(player, newActiveLevels);
    }

    private static void processLevelTransitions(Player player, Set<ResourceLocation> lastActiveLevels, Set<ResourceLocation> newActiveLevels) {
        HashSet<ResourceLocation> removedLevels = new HashSet<ResourceLocation>(lastActiveLevels);
        removedLevels.removeAll(newActiveLevels);
        for (ResourceLocation levelId : removedLevels) {
            RadiationLevel level = RadiationLevelRegistry.getRadiationLevel(levelId);
            if (level == null) continue;
            RadiationHandler.onLevelDeactivated(player, level);
        }
        HashSet<ResourceLocation> addedLevels = new HashSet<ResourceLocation>(newActiveLevels);
        addedLevels.removeAll(lastActiveLevels);
        for (ResourceLocation levelId : addedLevels) {
            RadiationLevel level = RadiationLevelRegistry.getRadiationLevel(levelId);
            if (level == null) continue;
            RadiationHandler.onLevelActivated(player, level);
        }
    }

    private static Set<ResourceLocation> determineActiveLevels(float radiation) {
        HashSet<ResourceLocation> activeLevels = new HashSet<ResourceLocation>();
        List<RadiationLevel> sortedLevels = RadiationLevelRegistry.getSortedLevels();
        boolean stacking = false;
        for (int i = sortedLevels.size() - 1; i >= 0; --i) {
            RadiationLevel level = sortedLevels.get(i);
            if (!(radiation >= (float)level.getRadiationThreshold())) continue;
            if (stacking) {
                activeLevels.add(level.getId());
                continue;
            }
            activeLevels.clear();
            activeLevels.add(level.getId());
            if (!level.isStackEffectsFromLowerLevels()) break;
            stacking = true;
        }
        return activeLevels;
    }

    private static void onLevelActivated(Player player, RadiationLevel level) {
        RadiationHandler.applyAttributeModifiers(player, level);
        RadiationHandler.executeCommands(player, level);
    }

    private static void onLevelDeactivated(Player player, RadiationLevel level) {
        RadiationHandler.removeAttributeModifiers(player, level);
        if (level.getRadiationDamage() != null && level.getRadiationDamage().isScaling()) {
            playerProgressiveDamage.computeIfAbsent(player.m_20148_(), k -> new ConcurrentHashMap()).remove(level.getId());
        }
    }

    private static void applyContinuousEffects(Player player, Set<ResourceLocation> activeLevels) {
        for (ResourceLocation levelId : activeLevels) {
            RadiationLevel level = RadiationLevelRegistry.getRadiationLevel(levelId);
            if (level == null) continue;
            RadiationHandler.applyTickBasedEffects(player, level);
        }
    }

    private static void applyTickBasedEffects(Player player, RadiationLevel level) {
        if (player.f_19797_ % level.getTickRate() == 0) {
            RadiationDamage damageInfo = level.getRadiationDamage();
            if (damageInfo != null) {
                float damageToApply = (float)damageInfo.getBase();
                if (damageInfo.isScaling()) {
                    Map playerDamageMap = playerProgressiveDamage.computeIfAbsent(player.m_20148_(), k -> new ConcurrentHashMap());
                    float currentScalingDamage = playerDamageMap.getOrDefault(level.getId(), Float.valueOf(0.0f)).floatValue();
                    damageToApply += currentScalingDamage;
                    damageToApply = (float)Math.min((double)damageToApply, damageInfo.getMaxDamage());
                    float nextDamage = currentScalingDamage + (float)damageInfo.getScalingPerTick();
                    playerDamageMap.put(level.getId(), Float.valueOf(nextDamage));
                }
                if (damageToApply > 0.0f && !player.m_5833_()) {
                    player.m_6469_(ModDamageTypes.get((LevelAccessor)player.m_9236_(), ModDamageTypes.RADIATION), damageToApply);
                }
            }
            if (level.getRadiationEffects() != null) {
                for (RadiationLevelEffect effectInfo : level.getRadiationEffects()) {
                    MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectInfo.getName()));
                    if (effect == null || player.m_5833_() || effectInfo.isApplyOnce() && player.m_21023_(effect) || !(player.m_9236_().f_46441_.m_188501_() < effectInfo.getChance())) continue;
                    player.m_7292_(new MobEffectInstance(effect, effectInfo.getDuration(), effectInfo.getAmplifier(), effectInfo.isAmbient(), effectInfo.showParticles()));
                }
            }
        }
    }

    private static void executeCommands(Player player, RadiationLevel level) {
        if (level.getExecuteCommands() == null || player.m_20194_() == null) {
            return;
        }
        CommandSourceStack source = player.m_20194_().m_129893_().m_165484_((CommandSource)player).m_81325_(2);
        for (String command : level.getExecuteCommands()) {
            player.m_20194_().m_129892_().m_230957_(source, command.replace("@p", player.m_36316_().getName()));
        }
    }

    private static void applyAttributeModifiers(Player player, RadiationLevel level) {
        if (level.getRadiationAttributeModification() == null) {
            return;
        }
        for (RadiationAttributeModifier modInfo : level.getRadiationAttributeModification()) {
            AttributeInstance instance;
            ResourceLocation attributeName = new ResourceLocation(modInfo.getName());
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeName);
            if (attribute == null || (instance = player.m_21051_(attribute)) == null) continue;
            UUID modifierUUID = UUID.nameUUIDFromBytes(modInfo.getName().getBytes());
            AttributeModifier modifier = new AttributeModifier(modifierUUID, "Radioactive." + attributeName.m_135815_(), modInfo.getValue(), modInfo.getOperation());
            instance.m_22120_(modifierUUID);
            if (modInfo.isPersistent()) {
                instance.m_22125_(modifier);
                continue;
            }
            instance.m_22118_(modifier);
        }
    }

    private static void removeAttributeModifiers(Player player, RadiationLevel level) {
        if (level.getRadiationAttributeModification() == null) {
            return;
        }
        for (RadiationAttributeModifier modInfo : level.getRadiationAttributeModification()) {
            ResourceLocation attributeName = new ResourceLocation(modInfo.getName());
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeName);
            if (attribute == null) continue;
            AttributeInstance instance = player.m_21051_(attribute);
            UUID modifierUUID = UUID.nameUUIDFromBytes(modInfo.getName().getBytes());
            if (instance == null || instance.m_22111_(modifierUUID) == null) continue;
            instance.m_22120_(modifierUUID);
        }
    }

    private static float distanceRadiation(Player p) {
        double threshold;
        double d = Math.hypot(p.m_20185_(), p.m_20189_());
        if (d <= (threshold = ((Double)RadioactiveCommonConfigs.DISTANCE_RADIATION_THRESHOLD.get()).doubleValue())) {
            return 0.0f;
        }
        float perBlock = ((Double)RadioactiveCommonConfigs.RADIATION_PER_BLOCK_DISTANCE.get()).floatValue();
        return (float)(d - threshold) * perBlock;
    }

    private static float sunRadiation(Player p) {
        if (!((Boolean)RadioactiveCommonConfigs.SUN_RADIATION.get()).booleanValue()) {
            return 0.0f;
        }
        if (!p.m_9236_().m_46461_() || !p.m_9236_().m_45527_(p.m_20183_())) {
            return 0.0f;
        }
        long t = p.m_9236_().m_46468_() % 24000L;
        float sunFactor = t < 12000L ? 1.0f - (float)Math.abs(t - 6000L) / 6000.0f : 0.0f;
        return ((Double)RadioactiveCommonConfigs.SUN_RADIATION_PEAK_RATE.get()).floatValue() * sunFactor;
    }

    private static float fogRadiation(Player p) {
        return p.m_21023_((MobEffect)ModEffects.TOXIC_PARTICLES.get()) ? ((Double)RadioactiveCommonConfigs.FOG_RADIATION_AMOUNT.get()).floatValue() : 0.0f;
    }

    private static float mobsRadiation(Player p) {
        List list = p.m_9236_().m_6443_(LivingEntity.class, p.m_20191_().m_82400_(((Double)RadioactiveCommonConfigs.MOB_RADIATION_RADIUS.get()).doubleValue()), e -> !(e instanceof Player) && e.m_6084_());
        float sum = 0.0f;
        for (LivingEntity m : list) {
            ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)m.m_6095_());
            float base = RadiationRegistry.getMobRadiation(id);
            if (base <= 0.0f) continue;
            AABB aabb = m.m_20191_();
            Rectangle rect = Rectangle.create(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
            RadiationSource src = new RadiationSource(base, Attenuation.FAST_INV_SQ, rect);
            float exposure = RadiationRaycast.calculateExposure(src, p, (ServerLevel)p.m_9236_());
            sum += src.contribution(p.m_20182_()) * exposure;
        }
        return sum;
    }

    private static float itemEntityRadiation(Player p) {
        List items = p.m_9236_().m_45976_(ItemEntity.class, p.m_20191_().m_82400_(((Double)RadioactiveCommonConfigs.ITEM_ENTITY_RADIATION_RADIUS.get()).doubleValue()));
        float sum = 0.0f;
        for (ItemEntity ent : items) {
            float base;
            ItemStack stack = ent.m_32055_();
            if (stack.m_41619_() || (base = RadiationRegistry.getItemRadiation(stack) * (float)stack.m_41613_()) <= 0.0f) continue;
            AABB aabb = ent.m_20191_();
            Rectangle rect = Rectangle.create(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
            RadiationSource src = new RadiationSource(base, Attenuation.HALF_LIFE, rect);
            float exposure = RadiationRaycast.calculateExposure(src, p, (ServerLevel)p.m_9236_());
            sum += src.contribution(p.m_20182_()) * exposure;
        }
        return sum;
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone e) {
        if (!e.isWasDeath()) {
            return;
        }
        if (!((Boolean)RadioactiveCommonConfigs.PERSIST_RADIATION_ON_DEATH.get()).booleanValue()) {
            Player p = e.getEntity();
            if (!p.m_9236_().f_46443_) {
                RadiationHelper.setRadiation((LivingEntity)p, 0.0f);
                RadiationHelper.setRadiationRate((LivingEntity)p, 0.0f);
                RadiationHelper.setRadiationResistance((LivingEntity)p, 0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        playerActiveRadiationLevels.remove(event.getEntity().m_20148_());
        playerProgressiveDamage.remove(event.getEntity().m_20148_());
    }
}

