/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.network.NetworkHandler;
import com.radar.radioactive.common.network.packets.S2CSyncRadiationPacket;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RadiationRegistry
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type MAP_TYPE = new TypeToken<Map<String, Float>>(){}.getType();
    private static final Map<ResourceLocation, Float> radioactiveBlocks = new HashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveItems = new HashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveBiomes = new HashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveDimensions = new HashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveMobs = new HashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveStructures = new HashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> reductionArmor = new HashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveBlockTags = new HashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveItemTags = new HashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveBiomeTags = new HashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveMobTags = new HashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> reductionArmorTags = new HashMap<ResourceLocation, Float>();
    private static final Map<String, Map<ResourceLocation, Float>> allDataMaps = new HashMap<String, Map<ResourceLocation, Float>>();

    public RadiationRegistry() {
        super(GSON, "radioactive");
    }

    public static float getBlockRadiation(ResourceLocation id) {
        if (radioactiveBlocks.containsKey(id)) {
            return radioactiveBlocks.get(id).floatValue();
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
        if (block != null) {
            return RadiationRegistry.getMaxTagRadiation(block.m_204297_().m_203616_(), radioactiveBlockTags);
        }
        return 0.0f;
    }

    public static float getBlockRadiation(Level level, BlockPos pos) {
        Block block = level.m_8055_(pos).m_60734_();
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
        float blockRadiation = RadiationRegistry.getBlockRadiation(blockId);
        ResourceLocation biomeId = ((ResourceKey)level.m_204166_(pos).m_203543_().get()).m_135782_();
        return blockRadiation += RadiationRegistry.getBiomeRadiation(biomeId);
    }

    public static float getItemRadiation(ResourceLocation id) {
        float itemRadiation;
        if (id == null) {
            Radioactive.LOGGER.warn("Attempted to get radiation for null item ID");
            return 0.0f;
        }
        float directItemRadiation = radioactiveItems.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        float tagRadiation = 0.0f;
        if (item != null) {
            tagRadiation = RadiationRegistry.getMaxTagRadiation(item.m_204114_().m_203616_(), radioactiveItemTags);
        }
        if ((itemRadiation = Math.max(directItemRadiation, tagRadiation)) == 0.0f && item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)blockItem.m_40614_());
            itemRadiation = RadiationRegistry.getBlockRadiation(blockId);
        }
        return itemRadiation;
    }

    public static float getItemRadiation(ItemStack item) {
        return RadiationRegistry.getItemRadiation(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()));
    }

    public static float getBiomeRadiation(ResourceLocation id) {
        if (radioactiveBiomes.containsKey(id)) {
            return radioactiveBiomes.get(id).floatValue();
        }
        return radioactiveBiomeTags.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public static float getBiomeRadiation(Level level, BlockPos pos) {
        ResourceLocation biomeId = ((ResourceKey)level.m_204166_(pos).m_203543_().get()).m_135782_();
        return RadiationRegistry.getBiomeRadiation(biomeId);
    }

    public static float getMobRadiation(ResourceLocation id) {
        if (radioactiveMobs.containsKey(id)) {
            return radioactiveMobs.get(id).floatValue();
        }
        return 0.0f;
    }

    public static float getStructureRadiation(ResourceLocation structureId) {
        return radioactiveStructures.getOrDefault(structureId, Float.valueOf(0.0f)).floatValue();
    }

    public static float getDimensionRadiation(ResourceLocation id) {
        return radioactiveDimensions.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public static float getArmorReduction(ResourceLocation id) {
        if (reductionArmor.containsKey(id)) {
            return reductionArmor.get(id).floatValue();
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        if (item != null) {
            return RadiationRegistry.getMaxTagRadiation(item.m_204114_().m_203616_(), reductionArmorTags);
        }
        return 0.0f;
    }

    public static float getArmorReduction(ItemStack item) {
        return RadiationRegistry.getArmorReduction(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()));
    }

    public static Map<ResourceLocation, Float> getRadioactiveStructures() {
        return radioactiveStructures;
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new RadiationRegistry());
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.clearAllData();
        Radioactive.LOGGER.info("Radiation registry reloading...");
        resourceMap.forEach((location, jsonElement) -> {
            try {
                this.processResource((ResourceLocation)location, (JsonElement)jsonElement);
            }
            catch (Exception e) {
                Radioactive.LOGGER.error("Error processing resource {}: {}", location, (Object)e.getMessage());
            }
        });
        this.logLoadedData();
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            Radioactive.LOGGER.info("Sending updated radiation data to all clients.");
            NetworkHandler.sendToAll(new S2CSyncRadiationPacket(radioactiveBlocks, radioactiveBlockTags, radioactiveItems, radioactiveItemTags, reductionArmor, reductionArmorTags));
        }
    }

    private void clearAllData() {
        radioactiveBlocks.clear();
        radioactiveItems.clear();
        radioactiveBiomes.clear();
        radioactiveDimensions.clear();
        radioactiveMobs.clear();
        radioactiveStructures.clear();
        reductionArmor.clear();
        radioactiveBlockTags.clear();
        radioactiveItemTags.clear();
        radioactiveBiomeTags.clear();
        radioactiveMobTags.clear();
        reductionArmorTags.clear();
    }

    private void processResource(ResourceLocation location, JsonElement jsonElement) {
        String path = location.m_135815_();
        Radioactive.LOGGER.debug("Processing resource: {}", (Object)location);
        if (path.contains("radioactive_blocks")) {
            this.loadData(jsonElement, radioactiveBlocks, radioactiveBlockTags, "block");
        } else if (path.contains("radioactive_items")) {
            this.loadData(jsonElement, radioactiveItems, radioactiveItemTags, "item");
        } else if (path.contains("radioactive_biomes")) {
            this.loadData(jsonElement, radioactiveBiomes, radioactiveBiomeTags, "biome");
        } else if (path.contains("radioactive_dimensions")) {
            this.loadData(jsonElement, radioactiveDimensions, "dimension");
        } else if (path.contains("radioactive_mobs")) {
            this.loadData(jsonElement, radioactiveMobs, radioactiveMobTags, "mob");
        } else if (path.contains("radioactive_structures")) {
            this.loadData(jsonElement, radioactiveStructures, null, "structure");
        } else if (path.contains("armor")) {
            this.loadData(jsonElement, reductionArmor, reductionArmorTags, "armor");
        } else {
            Radioactive.LOGGER.debug("Skipping unknown radioactive data file: {}", (Object)location);
        }
    }

    private void logLoadedData() {
        Radioactive.LOGGER.info("--- Radiation Registry Loading Complete ---");
        this.logMapData("item", radioactiveItems, radioactiveItemTags);
        this.logMapData("block", radioactiveBlocks, radioactiveBlockTags);
        this.logMapData("biome", radioactiveBiomes, radioactiveBiomeTags);
        this.logMapData("mob", radioactiveMobs, radioactiveMobTags);
        this.logMapData("structure", radioactiveStructures, null);
        this.logMapData("armor reduction", reductionArmor, reductionArmorTags);
        Radioactive.LOGGER.info("-------------------------------------------");
    }

    private void logMapData(String name, Map<ResourceLocation, Float> directMap, Map<ResourceLocation, Float> tagMap) {
        if (!directMap.isEmpty() || tagMap != null && !tagMap.isEmpty()) {
            int directSize = directMap.size();
            int tagSize = tagMap != null ? tagMap.size() : 0;
            Radioactive.LOGGER.info("Loaded {} radioactive {} entries ({} direct, {} tags)", (Object)(directSize + tagSize), (Object)name, (Object)directSize, (Object)tagSize);
        }
    }

    private void loadData(JsonElement json, Map<ResourceLocation, Float> directMap, Map<ResourceLocation, Float> tagMap, String dataType) {
        try {
            Map data = (Map)GSON.fromJson(json, MAP_TYPE);
            if (data == null) {
                return;
            }
            data.forEach((key, value) -> {
                if (key.startsWith("#")) {
                    if (tagMap != null) {
                        ResourceLocation id = new ResourceLocation(key.substring(1));
                        tagMap.put(id, (Float)value);
                    } else {
                        Radioactive.LOGGER.warn("Found a tag entry '{}' for data type '{}' which does not support tags. Entry skipped.", key, (Object)dataType);
                    }
                } else {
                    ResourceLocation id = new ResourceLocation(key);
                    directMap.put(id, (Float)value);
                }
            });
        }
        catch (JsonSyntaxException e) {
            Radioactive.LOGGER.error("Error parsing JSON for {} data: {}", (Object)dataType, (Object)e.getMessage());
        }
    }

    private void loadData(JsonElement json, Map<ResourceLocation, Float> directMap, String dataType) {
        try {
            Map data = (Map)GSON.fromJson(json, MAP_TYPE);
            if (data == null) {
                return;
            }
            data.forEach((key, value) -> {
                ResourceLocation id = new ResourceLocation(key);
                directMap.put(id, (Float)value);
            });
        }
        catch (JsonSyntaxException e) {
            Radioactive.LOGGER.error("Error parsing JSON for {} data: {}", (Object)dataType, (Object)e.getMessage());
        }
    }

    private static <T> float getMaxTagRadiation(Stream<TagKey<T>> tagsStream, Map<ResourceLocation, Float> tagRadiationMap) {
        return (float)tagsStream.map(TagKey::f_203868_).mapToDouble(tagId -> tagRadiationMap.getOrDefault(tagId, Float.valueOf(0.0f)).floatValue()).max().orElse(0.0);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Radioactive.LOGGER.info("Sending radiation data to player: {}", (Object)player2.m_7755_().getString());
            NetworkHandler.sendToPlayer(new S2CSyncRadiationPacket(radioactiveBlocks, radioactiveBlockTags, radioactiveItems, radioactiveItemTags, reductionArmor, reductionArmorTags), player2);
        }
    }

    public static void updateClientData(Map<ResourceLocation, Float> blocks, Map<ResourceLocation, Float> blockTags, Map<ResourceLocation, Float> items, Map<ResourceLocation, Float> itemTags, Map<ResourceLocation, Float> armor, Map<ResourceLocation, Float> armorTags) {
        Radioactive.LOGGER.info("Receiving radiation data from server.");
        radioactiveBlocks.clear();
        radioactiveBlocks.putAll(blocks);
        radioactiveBlockTags.clear();
        radioactiveBlockTags.putAll(blockTags);
        radioactiveItems.clear();
        radioactiveItems.putAll(items);
        radioactiveItemTags.clear();
        radioactiveItemTags.putAll(itemTags);
        reductionArmor.clear();
        reductionArmor.putAll(armor);
        reductionArmorTags.clear();
        reductionArmorTags.putAll(armorTags);
    }

    static {
        allDataMaps.put("blocks", radioactiveBlocks);
        allDataMaps.put("blockTags", radioactiveBlockTags);
        allDataMaps.put("items", radioactiveItems);
        allDataMaps.put("itemTags", radioactiveItemTags);
    }
}

