/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.capabilities;

import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.radiation.capabilities.IRadiationCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public class PlayerRadiation
implements IRadiationCapability,
INBTSerializable<CompoundTag> {
    private float radiation = 0.0f;
    private float exposureRate = 0.0f;
    private float resistance = 0.0f;

    @Override
    public float getRadiation() {
        return this.radiation;
    }

    @Override
    public void setRadiation(float radiation) {
        this.radiation = RadioactiveCommonConfigs.clampRadiation(radiation);
    }

    @Override
    public float getExposureRate() {
        return this.exposureRate;
    }

    @Override
    public void setExposureRate(float rate) {
        this.exposureRate = rate;
    }

    @Override
    public float getResistance() {
        return this.resistance;
    }

    @Override
    public void setResistance(float resistance) {
        this.resistance = Math.min(1.0f, Math.max(0.0f, resistance));
    }

    @Override
    public void tick() {
        this.handleRadiationDecay();
        this.handleRadiationExposure();
    }

    private void handleRadiationDecay() {
        float adjustedDecayRate;
        if (!((Boolean)RadioactiveCommonConfigs.ENABLE_RADIATION_DECAY.get()).booleanValue() || this.radiation <= 0.0f) {
            return;
        }
        float minThreshold = ((Double)RadioactiveCommonConfigs.MINIMUM_DECAY_THRESHOLD.get()).floatValue();
        if (this.radiation <= minThreshold) {
            return;
        }
        float baseDecayRate = ((Double)RadioactiveCommonConfigs.RADIATION_DECAY_RATE.get()).floatValue();
        if (baseDecayRate <= 0.0f) {
            return;
        }
        float oldRadiation = this.radiation;
        float decayMultiplier = this.calculateDecayMultiplier(this.radiation);
        float decayPerCall = adjustedDecayRate = baseDecayRate * decayMultiplier;
        float newRadiation = Math.max(minThreshold, this.radiation - decayPerCall);
        this.setRadiation(newRadiation);
    }

    private float calculateDecayMultiplier(float currentRadiation) {
        float highThreshold = ((Double)RadioactiveCommonConfigs.DECAY_BOOST_THRESHOLD.get()).floatValue();
        float lowThreshold = ((Double)RadioactiveCommonConfigs.DECAY_REDUCTION_THRESHOLD.get()).floatValue();
        if (currentRadiation >= highThreshold) {
            return ((Double)RadioactiveCommonConfigs.HIGH_RADIATION_DECAY_MULTIPLIER.get()).floatValue();
        }
        if (currentRadiation <= lowThreshold) {
            return ((Double)RadioactiveCommonConfigs.LOW_RADIATION_DECAY_MULTIPLIER.get()).floatValue();
        }
        return 1.0f;
    }

    private void handleRadiationExposure() {
        if (this.exposureRate <= 0.0f) {
            return;
        }
        float effectiveExposure = this.exposureRate * (1.0f - this.resistance);
        float increase = effectiveExposure;
        if (increase > 0.0f) {
            float oldRadiation = this.radiation;
            this.setRadiation(this.radiation + increase);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("Radiation", this.radiation);
        tag.m_128350_("ExposureRate", this.exposureRate);
        tag.m_128350_("Resistance", this.resistance);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.radiation = nbt.m_128457_("Radiation");
        this.exposureRate = nbt.m_128457_("ExposureRate");
        this.resistance = nbt.m_128457_("Resistance");
    }
}

