/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.level;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;

public class RadiationDamage {
    @SerializedName(value="base")
    private double base = 0.0;
    @SerializedName(value="scaling_per_tick")
    private double scalingPerTick = 0.0;
    @SerializedName(value="max_damage")
    private double maxDamage = Double.MAX_VALUE;

    public RadiationDamage() {
    }

    public RadiationDamage(double base) {
        this.base = base;
    }

    public double getBase() {
        return this.base;
    }

    public double getScalingPerTick() {
        return this.scalingPerTick;
    }

    public double getMaxDamage() {
        if (this.maxDamage == 0.0) {
            return Double.MAX_VALUE;
        }
        return this.maxDamage;
    }

    public boolean isScaling() {
        return this.scalingPerTick > 0.0;
    }

    public static class Deserializer
    implements JsonDeserializer<RadiationDamage> {
        public RadiationDamage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return new RadiationDamage(json.getAsDouble());
            }
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                RadiationDamage damage = new RadiationDamage();
                if (obj.has("base")) {
                    damage.base = obj.get("base").getAsDouble();
                }
                if (obj.has("scaling_per_tick")) {
                    damage.scalingPerTick = obj.get("scaling_per_tick").getAsDouble();
                }
                if (obj.has("max_damage")) {
                    damage.maxDamage = obj.get("max_damage").getAsDouble();
                }
                return damage;
            }
            throw new JsonParseException("Expected a number or an object for RadiationDamage");
        }
    }
}

