/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.sources;

import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.radiation.capabilities.RadiationCapabilities;
import com.radar.radioactive.common.radiation.sources.IRadiationSourceProvider;
import com.radar.radioactive.common.radiation.spatial.GlobalRadiationIndexAPI;
import com.radar.radioactive.common.radiation.spatial.SafeChunkRegistryAPI;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;

public class BlockRadiationProvider
implements IRadiationSourceProvider {
    @Override
    public float getRadiation(Player p) {
        if (SafeChunkRegistryAPI.isSafe(p.m_9236_(), p.m_146902_())) {
            return 0.0f;
        }
        ServerLevel level = (ServerLevel)p.m_9236_();
        float blockRadius = ((Double)RadioactiveCommonConfigs.ENVIRONMENTAL_SCAN_RADIUS.get()).floatValue();
        int chunkRadius = (Integer)RadioactiveCommonConfigs.PLAYER_SCAN_RADIUS_CHUNKS.get();
        float globalRad = GlobalRadiationIndexAPI.of(level).flux(p.m_20182_(), blockRadius, p, level);
        AtomicReference<Float> localBlockRad = new AtomicReference<Float>(Float.valueOf(0.0f));
        ChunkPos playerChunkPos = p.m_146902_();
        for (int cz = -chunkRadius; cz <= chunkRadius; ++cz) {
            for (int cx = -chunkRadius; cx <= chunkRadius; ++cx) {
                ChunkPos pos = new ChunkPos(playerChunkPos.f_45578_ + cx, playerChunkPos.f_45579_ + cz);
                LevelChunk chunk = level.m_7726_().m_7131_(pos.f_45578_, pos.f_45579_);
                if (chunk == null) continue;
                chunk.getCapability(RadiationCapabilities.CHUNK_RADIATION).ifPresent(cap -> localBlockRad.updateAndGet(v -> Float.valueOf(v.floatValue() + cap.getIndex().flux(p.m_20182_(), blockRadius, p, level))));
            }
        }
        return globalRad + localBlockRad.get().floatValue();
    }
}

