/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.sources;

import com.davidmoten.rtree.geometry.Rectangle;
import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.radiation.RadiationRegistry;
import com.radar.radioactive.common.radiation.sources.IRadiationSourceProvider;
import com.radar.radioactive.common.radiation.spatial.Attenuation;
import com.radar.radioactive.common.radiation.spatial.RadiationRaycast;
import com.radar.radioactive.common.radiation.spatial.RadiationSource;
import com.radar.radioactive.common.radiation.spatial.SafeChunkRegistryAPI;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityRadiationProvider
implements IRadiationSourceProvider {
    private static final Map<UUID, Float> playerMobRadiationCache = new ConcurrentHashMap<UUID, Float>();

    @Override
    public float getRadiation(Player p) {
        float mobRad;
        if (SafeChunkRegistryAPI.isSafe(p.m_9236_(), p.m_146902_())) {
            return 0.0f;
        }
        if (p.f_19797_ % (Integer)RadioactiveCommonConfigs.MOB_RADIATION_CACHE_INTERVAL.get() == 0 || !playerMobRadiationCache.containsKey(p.m_20148_())) {
            mobRad = this.mobsRadiation(p);
            playerMobRadiationCache.put(p.m_20148_(), Float.valueOf(mobRad));
        } else {
            mobRad = playerMobRadiationCache.getOrDefault(p.m_20148_(), Float.valueOf(0.0f)).floatValue();
        }
        float itemRad = this.itemEntityRadiation(p);
        return mobRad + itemRad;
    }

    private float mobsRadiation(Player p) {
        List list = p.m_9236_().m_6443_(LivingEntity.class, p.m_20191_().m_82400_(((Double)RadioactiveCommonConfigs.MOB_RADIATION_RADIUS.get()).doubleValue()), e -> !(e instanceof Player) && e.m_6084_());
        float sum = 0.0f;
        for (LivingEntity m : list) {
            ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)m.m_6095_());
            float base = RadiationRegistry.getMobRadiation(id);
            if (base <= 0.0f) continue;
            AABB aabb = m.m_20191_();
            Rectangle rect = Rectangle.create(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
            RadiationSource src = new RadiationSource(base, Attenuation.FAST_INV_SQ, rect);
            float exposure = RadiationRaycast.calculateExposure(src, p, (ServerLevel)p.m_9236_());
            sum += src.contribution(p.m_20182_()) * exposure;
        }
        return sum;
    }

    private float itemEntityRadiation(Player p) {
        List items = p.m_9236_().m_45976_(ItemEntity.class, p.m_20191_().m_82400_(((Double)RadioactiveCommonConfigs.ITEM_ENTITY_RADIATION_RADIUS.get()).doubleValue()));
        float sum = 0.0f;
        for (ItemEntity ent : items) {
            float base;
            ItemStack stack = ent.m_32055_();
            if (stack.m_41619_() || (base = RadiationRegistry.getItemRadiation(stack) * (float)stack.m_41613_()) <= 0.0f) continue;
            AABB aabb = ent.m_20191_();
            Rectangle rect = Rectangle.create(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
            RadiationSource src = new RadiationSource(base, Attenuation.HALF_LIFE, rect);
            float exposure = RadiationRaycast.calculateExposure(src, p, (ServerLevel)p.m_9236_());
            sum += src.contribution(p.m_20182_()) * exposure;
        }
        return sum;
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        playerMobRadiationCache.remove(event.getEntity().m_20148_());
    }
}

