/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.spatial;

import com.davidmoten.rtree.Entry;
import com.davidmoten.rtree.geometry.Geometry;
import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.radiation.spatial.RadiationIndex;
import com.radar.radioactive.common.radiation.spatial.RadiationNBTUtil;
import com.radar.radioactive.common.radiation.spatial.RadiationSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class ChunkRadiation
implements INBTSerializable<CompoundTag> {
    private final RadiationIndex index = new RadiationIndex();

    public RadiationIndex getIndex() {
        return this.index;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag sourceList = new ListTag();
        for (Entry<RadiationSource, Geometry> entry : this.index.entries()) {
            sourceList.add((Object)RadiationNBTUtil.toNBT(entry.value()));
        }
        nbt.m_128365_("Sources", (Tag)sourceList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag sourceList = nbt.m_128437_("Sources", 10);
        for (Tag tag : sourceList) {
            try {
                RadiationSource src = RadiationNBTUtil.fromNBT((CompoundTag)tag);
                this.index.add(src);
            }
            catch (Exception e) {
                Radioactive.LOGGER.error((Object)e);
            }
        }
    }
}

