/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.spatial;

import com.davidmoten.rtree.Entry;
import com.davidmoten.rtree.geometry.Geometry;
import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.radiation.spatial.RadiationIndex;
import com.radar.radioactive.common.radiation.spatial.RadiationNBTUtil;
import com.radar.radioactive.common.radiation.spatial.RadiationSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class GlobalRadiationWorldData
extends SavedData {
    public static final String DATA_NAME = "radioactive_global_radiation";
    private final RadiationIndex index;

    private GlobalRadiationWorldData(RadiationIndex index) {
        this.index = index;
    }

    public static GlobalRadiationWorldData create() {
        Radioactive.LOGGER.debug("Creating new GlobalRadiationWorldData");
        return new GlobalRadiationWorldData(new RadiationIndex());
    }

    public static GlobalRadiationWorldData load(CompoundTag nbt) {
        Radioactive.LOGGER.debug("Loading GlobalRadiationWorldData from NBT");
        RadiationIndex idx = new RadiationIndex();
        ListTag list = nbt.m_128437_("Sources", 10);
        for (Tag t : list) {
            CompoundTag c = (CompoundTag)t;
            try {
                RadiationSource src = RadiationNBTUtil.fromNBT(c);
                idx.add(src);
            }
            catch (Exception e) {
                Radioactive.LOGGER.error("Failed to load radiation source from NBT: {}", (Object)c, (Object)e);
            }
        }
        Radioactive.LOGGER.debug("Loaded {} sources from NBT", (Object)list.size());
        return new GlobalRadiationWorldData(idx);
    }

    public static GlobalRadiationWorldData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalArgumentException("GlobalRadiationWorldData can only be accessed server-side");
        }
        ServerLevel sl = (ServerLevel)level;
        return (GlobalRadiationWorldData)sl.m_8895_().m_164861_(GlobalRadiationWorldData::load, GlobalRadiationWorldData::create, DATA_NAME);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (Entry<RadiationSource, Geometry> e : this.index.entries()) {
            list.add((Object)RadiationNBTUtil.toNBT(e.value()));
        }
        nbt.m_128365_("Sources", (Tag)list);
        Radioactive.LOGGER.debug("Saved {} radiation sources to disk", (Object)list.size());
        return nbt;
    }

    public RadiationIndex getIndex() {
        this.m_77762_();
        return this.index;
    }
}

