/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.spatial;

import com.davidmoten.rtree.geometry.Rectangle;
import com.radar.radioactive.common.radiation.spatial.Attenuation;
import com.radar.radioactive.common.radiation.spatial.RadiationSource;
import net.minecraft.nbt.CompoundTag;

public final class RadiationNBTUtil {
    private RadiationNBTUtil() {
    }

    public static CompoundTag toNBT(RadiationSource src) {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("strength", src.strength());
        tag.m_128359_("law", src.law().name());
        double[] mins = src.bounds().mins();
        double[] maxes = src.bounds().maxes();
        tag.m_128347_("minX", mins[0]);
        tag.m_128347_("minY", mins[1]);
        tag.m_128347_("minZ", mins[2]);
        tag.m_128347_("maxX", maxes[0]);
        tag.m_128347_("maxY", maxes[1]);
        tag.m_128347_("maxZ", maxes[2]);
        return tag;
    }

    public static RadiationSource fromNBT(CompoundTag tag) {
        float strength = tag.m_128457_("strength");
        Attenuation law = Attenuation.valueOf(tag.m_128461_("law"));
        double minX = tag.m_128459_("minX");
        double minY = tag.m_128459_("minY");
        double minZ = tag.m_128459_("minZ");
        double maxX = tag.m_128459_("maxX");
        double maxY = tag.m_128459_("maxY");
        double maxZ = tag.m_128459_("maxZ");
        Rectangle rect = Rectangle.create(minX, minY, minZ, maxX, maxY, maxZ);
        return new RadiationSource(strength, law, rect);
    }
}

