/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.spatial;

import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.radiation.spatial.RadiationSource;
import com.radar.radioactive.common.tags.ModTags;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RadiationRaycast {
    private static final Map<TagKey<Block>, Float> SHIELDING_TAGS = new HashMap<TagKey<Block>, Float>();
    private static final Map<Block, Float> BLOCK_SHIELDING_CACHE = new ConcurrentHashMap<Block, Float>();
    private static final Map<ResourceLocation, Map<Long, Map<Integer, CachedRaycastResult>>> RAYCAST_CACHE = new ConcurrentHashMap<ResourceLocation, Map<Long, Map<Integer, CachedRaycastResult>>>();
    private static final Map<ResourceLocation, Set<ChunkPos>> MODIFIED_CHUNKS = new ConcurrentHashMap<ResourceLocation, Set<ChunkPos>>();
    private static int cleanupCounter = 0;
    private static final int CLEANUP_INTERVAL = 6000;

    private static void initializeShieldingTags() {
        SHIELDING_TAGS.clear();
        SHIELDING_TAGS.put(ModTags.LIGHT_SHIELDING, Float.valueOf(0.1f));
        SHIELDING_TAGS.put(ModTags.MEDIUM_SHIELDING, Float.valueOf(0.3f));
        SHIELDING_TAGS.put(ModTags.HEAVY_SHIELDING, Float.valueOf(0.6f));
        SHIELDING_TAGS.put(ModTags.TOTAL_SHIELDING, Float.valueOf(0.95f));
        SHIELDING_TAGS.put(ModTags.STONE_ORE_REPLACEABLES, Float.valueOf(0.25f));
        SHIELDING_TAGS.put(ModTags.METAL_STORAGE_BLOCKS, Float.valueOf(0.5f));
    }

    public static float calculateExposure(RadiationSource source, Player player, ServerLevel level) {
        Vec3 playerPos = player.m_20182_();
        Vec3 sourceCenter = RadiationRaycast.getSourceCenter(source);
        BlockPos playerBlockPos = player.m_20183_();
        ResourceLocation dimension = level.m_46472_().m_135782_();
        CachedRaycastResult cachedResult = RadiationRaycast.getCachedRaycast(level, playerBlockPos, source);
        if (cachedResult != null) {
            boolean isCacheStillValid = true;
            Set<ChunkPos> modifiedInDim = MODIFIED_CHUNKS.get(dimension);
            if (modifiedInDim != null && !modifiedInDim.isEmpty()) {
                for (ChunkPos traversedChunk : cachedResult.traversedChunks()) {
                    if (!modifiedInDim.contains(traversedChunk)) continue;
                    isCacheStillValid = false;
                    break;
                }
            }
            if (isCacheStillValid) {
                return cachedResult.exposureFactor();
            }
        }
        CachedRaycastResult newResult = RadiationRaycast.performRaycast(level, playerPos, sourceCenter);
        RadiationRaycast.cacheRaycastResult(level, playerBlockPos, source, newResult);
        return newResult.exposureFactor();
    }

    private static CachedRaycastResult getCachedRaycast(ServerLevel level, BlockPos playerPos, RadiationSource source) {
        Map<Long, Map<Integer, CachedRaycastResult>> dimensionCache = RAYCAST_CACHE.get(level.m_46472_().m_135782_());
        if (dimensionCache == null) {
            return null;
        }
        Map<Integer, CachedRaycastResult> positionCache = dimensionCache.get(RadiationRaycast.positionHash(playerPos));
        if (positionCache == null) {
            return null;
        }
        return positionCache.get(source.hashCode());
    }

    private static void cacheRaycastResult(ServerLevel level, BlockPos playerPos, RadiationSource source, CachedRaycastResult result) {
        ResourceLocation dimension = level.m_46472_().m_135782_();
        Map dimCache = RAYCAST_CACHE.computeIfAbsent(dimension, k -> new ConcurrentHashMap());
        Map posCache = dimCache.computeIfAbsent(RadiationRaycast.positionHash(playerPos), k -> new ConcurrentHashMap());
        posCache.put(source.hashCode(), result);
    }

    private static CachedRaycastResult performRaycast(ServerLevel level, Vec3 start, Vec3 end) {
        if (start.m_82557_(end) > 40000.0) {
            return new CachedRaycastResult(0.0f, Collections.emptySet());
        }
        int x0 = (int)Math.floor(start.f_82479_);
        int y0 = (int)Math.floor(start.f_82480_);
        int z0 = (int)Math.floor(start.f_82481_);
        int x1 = (int)Math.floor(end.f_82479_);
        int y1 = (int)Math.floor(end.f_82480_);
        int z1 = (int)Math.floor(end.f_82481_);
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int dz = Math.abs(z1 - z0);
        int stepX = x0 < x1 ? 1 : -1;
        int stepY = y0 < y1 ? 1 : -1;
        int stepZ = z0 < z1 ? 1 : -1;
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(x0, y0, z0);
        HashSet<ChunkPos> traversedChunks = new HashSet<ChunkPos>();
        float cumulativeShielding = 0.0f;
        if (dx >= dy && dx >= dz) {
            err1 = 2 * dy - dx;
            int err2 = 2 * dz - dx;
            for (int i = 0; i < dx; ++i) {
                cumulativeShielding = RadiationRaycast.processBlock(level, (BlockPos)currentPos, traversedChunks, cumulativeShielding);
                if (err1 > 0) {
                    y0 += stepY;
                    err1 -= 2 * dx;
                }
                if (err2 > 0) {
                    z0 += stepZ;
                    err2 -= 2 * dx;
                }
                err1 += 2 * dy;
                err2 += 2 * dz;
                currentPos.m_122178_(x0 += stepX, y0, z0);
            }
        } else if (dy >= dx && dy >= dz) {
            err1 = 2 * dx - dy;
            int err2 = 2 * dz - dy;
            for (int i = 0; i < dy; ++i) {
                cumulativeShielding = RadiationRaycast.processBlock(level, (BlockPos)currentPos, traversedChunks, cumulativeShielding);
                if (err1 > 0) {
                    x0 += stepX;
                    err1 -= 2 * dy;
                }
                if (err2 > 0) {
                    z0 += stepZ;
                    err2 -= 2 * dy;
                }
                err1 += 2 * dx;
                err2 += 2 * dz;
                currentPos.m_122178_(x0, y0 += stepY, z0);
            }
        } else {
            err1 = 2 * dx - dz;
            int err2 = 2 * dy - dz;
            for (int i = 0; i < dz; ++i) {
                cumulativeShielding = RadiationRaycast.processBlock(level, (BlockPos)currentPos, traversedChunks, cumulativeShielding);
                if (err1 > 0) {
                    x0 += stepX;
                    err1 -= 2 * dz;
                }
                if (err2 > 0) {
                    y0 += stepY;
                    err2 -= 2 * dz;
                }
                err1 += 2 * dx;
                err2 += 2 * dy;
                currentPos.m_122178_(x0, y0, z0 += stepZ);
            }
        }
        cumulativeShielding = RadiationRaycast.processBlock(level, (BlockPos)currentPos, traversedChunks, cumulativeShielding);
        float finalExposure = 1.0f - Math.min(1.0f, cumulativeShielding);
        return new CachedRaycastResult(finalExposure, traversedChunks);
    }

    private static float processBlock(ServerLevel level, BlockPos pos, Set<ChunkPos> traversedChunks, float cumulativeShielding) {
        traversedChunks.add(new ChunkPos(pos));
        BlockState state = level.m_8055_(pos);
        if (!state.m_60795_()) {
            float blockShielding = RadiationRaycast.getBlockShielding(state.m_60734_());
            return cumulativeShielding + blockShielding * (1.0f - cumulativeShielding);
        }
        return cumulativeShielding;
    }

    private static float getBlockShielding(Block block) {
        return BLOCK_SHIELDING_CACHE.computeIfAbsent(block, b -> {
            float highestValue = 0.0f;
            for (Map.Entry<TagKey<Block>, Float> entry : SHIELDING_TAGS.entrySet()) {
                if (!ForgeRegistries.BLOCKS.tags().getTag(entry.getKey()).contains(b) || !(entry.getValue().floatValue() > highestValue)) continue;
                highestValue = entry.getValue().floatValue();
            }
            return Float.valueOf(highestValue);
        }).floatValue();
    }

    public static void markChunkModified(ServerLevel level, ChunkPos pos) {
        MODIFIED_CHUNKS.computeIfAbsent(level.m_46472_().m_135782_(), k -> ConcurrentHashMap.newKeySet()).add(pos);
    }

    private static long positionHash(BlockPos pos) {
        return ((long)pos.m_123341_() & 0x3FFFFFFL) << 38 | ((long)pos.m_123342_() & 0xFFFL) << 26 | (long)pos.m_123343_() & 0x3FFFFFFL;
    }

    private static Vec3 getSourceCenter(RadiationSource source) {
        double[] mins = source.bounds().mins();
        double[] maxes = source.bounds().maxes();
        return new Vec3((mins[0] + maxes[0]) / 2.0, (mins[1] + maxes[1]) / 2.0, (mins[2] + maxes[2]) / 2.0);
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            RadiationRaycast.markChunkModified(level, new ChunkPos(event.getPos()));
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor;
        if (!event.isCanceled() && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            RadiationRaycast.markChunkModified(level, new ChunkPos(event.getPos()));
        }
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            Radioactive.LOGGER.info("Datapacks reloaded. Re-initializing shielding tags and clearing caches to apply new shielding rules.");
            RadiationRaycast.initializeShieldingTags();
            BLOCK_SHIELDING_CACHE.clear();
            RAYCAST_CACHE.clear();
            MODIFIED_CHUNKS.clear();
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++cleanupCounter >= 6000) {
            cleanupCounter = 0;
            RAYCAST_CACHE.clear();
            MODIFIED_CHUNKS.clear();
            Radioactive.LOGGER.debug("Cleared radiation caches during periodic cleanup.");
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            ResourceLocation dimension = level.m_46472_().m_135782_();
            RAYCAST_CACHE.remove(dimension);
            MODIFIED_CHUNKS.remove(dimension);
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        BLOCK_SHIELDING_CACHE.clear();
        RAYCAST_CACHE.clear();
        MODIFIED_CHUNKS.clear();
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        RadiationRaycast.onServerStarted(null);
    }

    private record CachedRaycastResult(float exposureFactor, Set<ChunkPos> traversedChunks) {
    }
}

