/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.spatial;

import com.radar.radioactive.common.radiation.capabilities.RadiationCapabilities;
import com.radar.radioactive.common.radiation.spatial.RadiationSource;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RadiationUpdateService {
    private static final Queue<UpdateCommand> UPDATE_QUEUE = new ConcurrentLinkedQueue<UpdateCommand>();

    public static void queueAdd(ServerLevel level, BlockPos pos, float radiation) {
        UPDATE_QUEUE.add(new UpdateCommand.Add(level, pos, radiation));
    }

    public static void queueRemove(ServerLevel level, BlockPos pos, float radiation) {
        UPDATE_QUEUE.add(new UpdateCommand.Remove(level, pos, radiation));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        int processed = 0;
        while (!UPDATE_QUEUE.isEmpty() && processed < 512) {
            UpdateCommand command = UPDATE_QUEUE.poll();
            if (command == null) continue;
            command.execute();
            ++processed;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface UpdateCommand {
        public void execute();

        public record Remove(ServerLevel level, BlockPos pos, float radiation) implements UpdateCommand
        {
            @Override
            public void execute() {
                LevelChunk chunk = this.level.m_46745_(this.pos);
                chunk.getCapability(RadiationCapabilities.CHUNK_RADIATION).ifPresent(cap -> {
                    cap.getIndex().remove(RadiationSource.block(this.pos, this.radiation));
                    chunk.m_8092_(true);
                });
            }
        }

        public record Add(ServerLevel level, BlockPos pos, float radiation) implements UpdateCommand
        {
            @Override
            public void execute() {
                LevelChunk chunk = this.level.m_46745_(this.pos);
                chunk.getCapability(RadiationCapabilities.CHUNK_RADIATION).ifPresent(cap -> {
                    cap.getIndex().add(RadiationSource.block(this.pos, this.radiation));
                    chunk.m_8092_(true);
                });
            }
        }
    }
}

