/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.radar.radioactive.common.radiation.ArmorUpgradeHandler;
import com.radar.radioactive.common.registry.ModRecipeSerializers;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;

public class DowngradeShapelessRecipe
implements CraftingRecipe {
    private final ResourceLocation id;
    private final ItemStack result;
    private final NonNullList<Ingredient> recipeItems;
    private final Ingredient armorIngredient;
    private final Ingredient toolIngredient;
    private final int requiredTier;
    private final int damageAmount;
    private final boolean isSimple;

    public DowngradeShapelessRecipe(ResourceLocation id, ItemStack result, NonNullList<Ingredient> recipeItems, Ingredient armorIngredient, Ingredient toolIngredient, int requiredTier, int damageAmount) {
        this.id = id;
        this.result = result;
        this.recipeItems = recipeItems;
        this.armorIngredient = armorIngredient;
        this.toolIngredient = toolIngredient;
        this.requiredTier = requiredTier;
        this.damageAmount = damageAmount;
        this.isSimple = recipeItems.stream().allMatch(Ingredient::isSimple);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.RADIOACTIVE_EXTRACTION.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public Ingredient getArmorIngredient() {
        return this.armorIngredient;
    }

    public boolean matches(CraftingContainer pContainer, Level pLevel) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < pContainer.m_6643_(); ++j) {
            ItemStack itemstack = pContainer.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            inputs.add(itemstack);
        }
        if (i != this.recipeItems.size()) {
            return false;
        }
        if (this.isSimple ? new StackedContents().m_36475_((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.recipeItems) != null) {
            for (ItemStack stack : inputs) {
                if (!this.armorIngredient.test(stack)) continue;
                return ArmorUpgradeHandler.getArmorTier(stack) == this.requiredTier;
            }
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pContainer) {
        NonNullList remainingItems = NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack damagedTool;
            ItemStack stack = pContainer.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.armorIngredient.test(stack)) {
                ItemStack downgradedArmor = stack.m_41777_();
                ArmorUpgradeHandler.downgradeArmor(downgradedArmor);
                remainingItems.set(i, (Object)downgradedArmor);
                continue;
            }
            if (!this.toolIngredient.test(stack) || !(damagedTool = stack.m_41777_()).m_41763_()) continue;
            damagedTool.m_41721_(damagedTool.m_41773_() + this.damageAmount);
            if (damagedTool.m_41773_() >= damagedTool.m_41776_()) continue;
            remainingItems.set(i, (Object)damagedTool);
        }
        return remainingItems;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= this.recipeItems.size();
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public Ingredient getToolIngredient() {
        return this.toolIngredient;
    }

    public int getRequiredTier() {
        return this.requiredTier;
    }

    public int getDamageAmount() {
        return this.damageAmount;
    }

    public static class Serializer
    implements RecipeSerializer<DowngradeShapelessRecipe> {
        public DowngradeShapelessRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            NonNullList<Ingredient> ingredients = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredients"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            Ingredient armor = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"armor_ingredient"));
            Ingredient tool = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"tool_ingredient"));
            int tier = GsonHelper.m_13927_((JsonObject)pJson, (String)"tier");
            int damage = GsonHelper.m_13927_((JsonObject)pJson, (String)"damage");
            return new DowngradeShapelessRecipe(pRecipeId, result, ingredients, armor, tool, tier, damage);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray pIngredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < pIngredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)pIngredientArray.get(i), (boolean)false);
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public DowngradeShapelessRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int size = pBuffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack result = pBuffer.m_130267_();
            Ingredient armor = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient tool = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            int tier = pBuffer.m_130242_();
            int damage = pBuffer.m_130242_();
            return new DowngradeShapelessRecipe(pRecipeId, result, (NonNullList<Ingredient>)ingredients, armor, tool, tier, damage);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, DowngradeShapelessRecipe pRecipe) {
            pBuffer.m_130130_(pRecipe.recipeItems.size());
            for (Ingredient ingredient : pRecipe.recipeItems) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.m_130055_(pRecipe.result);
            pRecipe.armorIngredient.m_43923_(pBuffer);
            pRecipe.toolIngredient.m_43923_(pBuffer);
            pBuffer.m_130130_(pRecipe.requiredTier);
            pBuffer.m_130130_(pRecipe.damageAmount);
        }
    }
}

