/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.radar.radioactive.common.radiation.ArmorUpgradeHandler;
import com.radar.radioactive.common.registry.ModRecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.Level;

public class UpgradeSmithingRecipe
extends SmithingTransformRecipe {
    private final Ingredient template;
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack result;
    private final int tier;

    public UpgradeSmithingRecipe(ResourceLocation id, Ingredient template, Ingredient base, Ingredient addition, ItemStack result, int tier) {
        super(id, template, base, addition, result);
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = result;
        this.tier = tier;
    }

    public boolean m_5818_(Container container, Level level) {
        boolean basicMatch = super.m_5818_(container, level);
        if (!basicMatch) {
            return false;
        }
        ItemStack baseStack = container.m_8020_(1);
        int currentTier = ArmorUpgradeHandler.getArmorTier(baseStack);
        if (this.tier == 1) {
            return currentTier == 0;
        }
        return currentTier == this.tier - 1;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        ItemStack baseStack = container.m_8020_(1).m_41777_();
        ArmorUpgradeHandler.applyUpgrade(baseStack, this.tier);
        return baseStack;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.RADIOACTIVE_UPGRADE.get();
    }

    public Ingredient getTemplate() {
        return this.template;
    }

    public Ingredient getAddition() {
        return this.addition;
    }

    public int getTier() {
        return this.tier;
    }

    public Ingredient getBase() {
        return this.base;
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeSmithingRecipe> {
        public UpgradeSmithingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient template = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"template"));
            Ingredient base = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"base"));
            Ingredient addition = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"addition"));
            ItemStack resultStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int tier = 1;
            if (json.has("tier")) {
                tier = GsonHelper.m_13927_((JsonObject)json, (String)"tier");
            }
            return new UpgradeSmithingRecipe(recipeId, template, base, addition, resultStack, tier);
        }

        public UpgradeSmithingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient template = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient addition = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            int tier = buffer.readInt();
            return new UpgradeSmithingRecipe(recipeId, template, base, addition, result, tier);
        }

        public void toNetwork(FriendlyByteBuf buffer, UpgradeSmithingRecipe recipe) {
            recipe.template.m_43923_(buffer);
            recipe.base.m_43923_(buffer);
            recipe.addition.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
            buffer.writeInt(recipe.tier);
        }
    }
}

