/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.radar.radioactive.common.radiation.ArmorUpgradeHandler;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class ArmorTierIngredient
extends Ingredient {
    public static final ResourceLocation NAME = new ResourceLocation("radioactive", "armor_tier");
    private final int tier;
    private ItemStack[] matchingStacks;

    public ArmorTierIngredient(int tier) {
        super(Stream.empty());
        this.tier = tier;
    }

    public int getTier() {
        return this.tier;
    }

    public ItemStack[] m_43908_() {
        if (this.matchingStacks == null) {
            this.matchingStacks = (ItemStack[])ForgeRegistries.ITEMS.getValues().stream().filter(i -> i instanceof ArmorItem).map(i -> {
                ItemStack stack = new ItemStack((ItemLike)i);
                if (this.tier > 0) {
                    ArmorUpgradeHandler.applyUpgrade(stack, this.tier);
                }
                return stack;
            }).toArray(ItemStack[]::new);
        }
        return this.matchingStacks;
    }

    public boolean test(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        if (!(itemStack.m_41720_() instanceof ArmorItem)) {
            return false;
        }
        return ArmorUpgradeHandler.getArmorTier(itemStack) == this.tier;
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    protected void invalidate() {
        this.matchingStacks = null;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", NAME.toString());
        jsonObject.addProperty("tier", (Number)this.tier);
        return jsonObject;
    }

    public static class Serializer
    implements IIngredientSerializer<ArmorTierIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public ArmorTierIngredient parse(FriendlyByteBuf buffer) {
            return new ArmorTierIngredient(buffer.m_130242_());
        }

        public ArmorTierIngredient parse(JsonObject json) {
            return new ArmorTierIngredient(GsonHelper.m_13927_((JsonObject)json, (String)"tier"));
        }

        public void write(FriendlyByteBuf buffer, ArmorTierIngredient ingredient) {
            buffer.m_130130_(ingredient.getTier());
        }
    }
}

