/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.taczadditions.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.raiiiden.taczadditions.client.GunRecoilHandler;
import com.raiiiden.taczadditions.config.TacZAdditionsConfig;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.client.renderer.item.GunItemRendererWrapper;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GunItemRendererWrapper.class}, remap=false)
public class GunMovementMixin {
    private static final float DEFAULT_PITCH_SENSITIVITY = 0.35f;
    private static final float DEFAULT_YAW_SENSITIVITY = 0.3f;
    private static final float DEFAULT_ROLL_SENSITIVITY = 1.2f;
    private static final float DEFAULT_DRAG_SMOOTHING = 0.15f;
    private static final float DEFAULT_DECAY_FACTOR = 0.84f;
    private static final float DEFAULT_MOMENTUM_FACTOR = 0.45f;
    private static final float DEFAULT_HIP_YAW_MULTIPLIER = 1.25f;
    private static final float DEFAULT_AIM_YAW_MULTIPLIER = 0.8f;
    private static final float DEFAULT_HIP_PITCH_MULTIPLIER = 1.2f;
    private static final float DEFAULT_HIP_ROLL_MULTIPLIER = 2.75f;
    private static final float DEFAULT_AIM_ROLL_MULTIPLIER = 2.75f;
    private static final float DEFAULT_MAX_ROLL_HIP = 20.0f;
    private static final float DEFAULT_MAX_ROLL_AIM = 20.0f;
    private static float smoothedPitch = 0.0f;
    private static float smoothedYaw = 0.0f;
    private static float smoothedRoll = 0.0f;
    private static float pitchVelocity = 0.0f;
    private static float yawVelocity = 0.0f;
    private static float rollVelocity = 0.0f;
    private static float smoothedStrafeYaw = 0.0f;
    private static float smoothedStrafeRoll = 0.0f;
    private static float strafeYawVelocity = 0.0f;
    private static float strafeRollVelocity = 0.0f;
    private static float lastPitch = 0.0f;
    private static float lastYaw = 0.0f;
    private static long lastFrameTime = 0L;

    @Inject(method={"renderFirstPerson"}, at={@At(value="HEAD")})
    private void applyCustomGunSway(LocalPlayer player, ItemStack stack, ItemDisplayContext ctx, PoseStack poseStack, MultiBufferSource bufferSource, int light, float partialTick, CallbackInfo ci) {
        float recoilProgress;
        if (!((Boolean)TacZAdditionsConfig.CLIENT.enableGunMovement.get()).booleanValue()) {
            return;
        }
        if (!(stack.m_41720_() instanceof AbstractGunItem)) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        float deltaTime = lastFrameTime == 0L ? 0.016f : Math.min(0.05f, (float)(currentTime - lastFrameTime) / 1000.0f);
        lastFrameTime = currentTime;
        float timeFactor = deltaTime * 60.0f;
        float currentPitch = player.m_5686_(partialTick);
        float currentYaw = player.m_5675_(partialTick);
        float deltaPitch = (currentPitch - lastPitch) * timeFactor;
        float deltaYaw = (currentYaw - lastYaw) * timeFactor;
        float aimingProgress = IClientPlayerGunOperator.fromLocalPlayer((LocalPlayer)player).getClientAimingProgress(partialTick);
        float hipYaw = GunMovementMixin.get("hipfireYawMultiplier", 1.25f);
        float aimYaw = GunMovementMixin.get("aimingYawMultiplier", 0.8f);
        float hipFireFactor = aimYaw + (1.0f - aimingProgress) * (hipYaw - aimYaw);
        float pitchMult = GunMovementMixin.get("hipfirePitchMultiplier", 1.2f);
        float hipFirePitchFactor = 1.0f + (1.0f - aimingProgress) * (pitchMult - 1.0f);
        float hipRoll = GunMovementMixin.get("hipfireRollFactor", 2.75f);
        float aimRoll = GunMovementMixin.get("aimingRollFactor", 2.75f);
        float hipFireRollFactor = aimRoll + (1.0f - aimingProgress) * (hipRoll - aimRoll);
        float drag = GunMovementMixin.get("dragSmoothing", 0.15f);
        float decay = GunMovementMixin.get("decayFactor", 0.84f);
        float momentum = GunMovementMixin.get("momentumFactor", 0.45f);
        float rollSens = GunMovementMixin.get("rollSensitivity", 1.2f);
        float maxRoll = GunMovementMixin.get("maxTiltAngle", 20.0f + 0.0f * (1.0f - aimingProgress));
        pitchVelocity = pitchVelocity * 0.85f + deltaPitch * drag * hipFirePitchFactor;
        yawVelocity = yawVelocity * 0.85f + deltaYaw * drag * hipFireFactor;
        rollVelocity = rollVelocity * 0.85f + -yawVelocity * 0.2f * hipFireRollFactor;
        smoothedPitch += pitchVelocity * momentum;
        smoothedYaw += yawVelocity * momentum;
        smoothedRoll += rollVelocity * momentum;
        smoothedPitch = (float)((double)smoothedPitch * Math.pow(decay, timeFactor));
        smoothedYaw = (float)((double)smoothedYaw * Math.pow(decay, timeFactor));
        smoothedRoll = (float)((double)smoothedRoll * Math.pow(decay, timeFactor));
        float oscillation = 0.03f * (1.0f - aimingProgress);
        smoothedPitch = (float)((double)smoothedPitch + Math.sin((double)currentTime * 0.003) * (double)oscillation);
        smoothedYaw = (float)((double)smoothedYaw + Math.sin((double)currentTime * 0.002) * (double)oscillation);
        float maxPitch = 10.0f + 8.0f * (1.0f - aimingProgress);
        float maxYaw = 10.0f + 12.0f * (1.0f - aimingProgress);
        smoothedPitch = GunMovementMixin.clamp(smoothedPitch, -maxPitch, maxPitch);
        smoothedYaw = GunMovementMixin.clamp(smoothedYaw, -maxYaw, maxYaw);
        smoothedRoll = GunMovementMixin.clamp(smoothedRoll, -maxRoll, maxRoll);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-smoothedPitch * 0.35f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(smoothedYaw * 0.3f * hipFireFactor * 0.9f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(smoothedRoll * rollSens));
        float xOffset = smoothedYaw * 0.012f * hipFireFactor * 0.9f;
        float yOffset = -smoothedPitch * 0.012f * hipFirePitchFactor;
        poseStack.m_252880_(xOffset, yOffset, 0.0f);
        if (((Boolean)TacZAdditionsConfig.CLIENT.enableStrafeMovement.get()).booleanValue()) {
            float strafeInput = Mth.m_14036_((float)player.f_20900_, (float)-1.0f, (float)1.0f);
            float strafeYawFactor = GunMovementMixin.lerp(aimingProgress, ((Double)TacZAdditionsConfig.CLIENT.aimStrafeYawMultiplier.get()).floatValue(), ((Double)TacZAdditionsConfig.CLIENT.strafeYawMultiplier.get()).floatValue());
            float strafeRollFactor = GunMovementMixin.lerp(aimingProgress, ((Double)TacZAdditionsConfig.CLIENT.aimStrafeRollMultiplier.get()).floatValue(), ((Double)TacZAdditionsConfig.CLIENT.strafeRollMultiplier.get()).floatValue());
            float strafeTargetYaw = strafeInput * strafeYawFactor;
            float strafeTargetRoll = strafeInput * strafeRollFactor;
            float strafeDrag = GunMovementMixin.get("strafeSmoothing", 0.15f);
            strafeYawVelocity = strafeYawVelocity * 0.85f + (strafeTargetYaw - smoothedStrafeYaw) * strafeDrag * timeFactor;
            strafeRollVelocity = strafeRollVelocity * 0.85f + (strafeTargetRoll - smoothedStrafeRoll) * strafeDrag * timeFactor;
            smoothedStrafeYaw += strafeYawVelocity * momentum * timeFactor;
            smoothedStrafeRoll += strafeRollVelocity * momentum * timeFactor;
            smoothedStrafeYaw = (float)((double)smoothedStrafeYaw * Math.pow(decay, timeFactor));
            smoothedStrafeRoll = (float)((double)smoothedStrafeRoll * Math.pow(decay, timeFactor));
            float maxStrafeYaw = ((Double)TacZAdditionsConfig.CLIENT.maxStrafeYaw.get()).floatValue();
            float maxStrafeRoll = ((Double)TacZAdditionsConfig.CLIENT.maxStrafeRoll.get()).floatValue();
            smoothedStrafeYaw = GunMovementMixin.clamp(smoothedStrafeYaw, -maxStrafeYaw, maxStrafeYaw);
            smoothedStrafeRoll = GunMovementMixin.clamp(smoothedStrafeRoll, -maxStrafeRoll, maxStrafeRoll);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(smoothedStrafeYaw));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(smoothedStrafeRoll));
        }
        if ((recoilProgress = 1.0f - (float)(System.currentTimeMillis() - GunRecoilHandler.lastRecoilTime) / 300.0f) > 0.0f) {
            recoilProgress *= recoilProgress;
            poseStack.m_252880_(GunRecoilHandler.recoilX * recoilProgress * 0.01f, GunRecoilHandler.recoilY * recoilProgress * 0.01f, GunRecoilHandler.recoilZ * recoilProgress * 0.01f);
        }
        lastPitch = currentPitch;
        lastYaw = currentYaw;
    }

    private static float get(String key, float def) {
        try {
            return switch (key) {
                case "hipfireRollFactor" -> ((Double)TacZAdditionsConfig.CLIENT.hipfireRollFactor.get()).floatValue();
                case "aimingRollFactor" -> ((Double)TacZAdditionsConfig.CLIENT.aimingRollFactor.get()).floatValue();
                case "rollSensitivity" -> ((Double)TacZAdditionsConfig.CLIENT.rollSensitivity.get()).floatValue();
                case "maxTiltAngle" -> ((Double)TacZAdditionsConfig.CLIENT.maxTiltAngle.get()).floatValue();
                case "hipfireYawMultiplier" -> ((Double)TacZAdditionsConfig.CLIENT.hipfireYawMultiplier.get()).floatValue();
                case "aimingYawMultiplier" -> ((Double)TacZAdditionsConfig.CLIENT.aimingYawMultiplier.get()).floatValue();
                case "hipfirePitchMultiplier" -> ((Double)TacZAdditionsConfig.CLIENT.hipfirePitchMultiplier.get()).floatValue();
                case "dragSmoothing" -> ((Double)TacZAdditionsConfig.CLIENT.dragSmoothing.get()).floatValue();
                case "decayFactor" -> ((Double)TacZAdditionsConfig.CLIENT.decayFactor.get()).floatValue();
                case "momentumFactor" -> ((Double)TacZAdditionsConfig.CLIENT.momentumFactor.get()).floatValue();
                case "strafeSmoothing" -> ((Double)TacZAdditionsConfig.CLIENT.strafeSmoothing.get()).floatValue();
                default -> def;
            };
        }
        catch (Exception e) {
            return def;
        }
    }

    private static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    private static float lerp(float alpha, float from, float to) {
        return from + (to - from) * (1.0f - alpha);
    }
}

