/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.taczadditions.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ServerMuzzleFlashManager {
    private static final Map<ServerLevel, Map<BlockPos, Long>> activeFlashes = new HashMap<ServerLevel, Map<BlockPos, Long>>();
    private static final long FLASH_DURATION_MS = 10L;

    public static void placeFlash(ServerLevel level, BlockPos pos, int lightLevel) {
        BlockPos targetPos = ServerMuzzleFlashManager.findValidPosition(level, pos);
        if (targetPos == null) {
            return;
        }
        try {
            IntegerProperty lightProp = (IntegerProperty)Blocks.f_152480_.m_49965_().m_61081_("level");
            level.m_7731_(targetPos, (BlockState)Blocks.f_152480_.m_49966_().m_61124_((Property)lightProp, (Comparable)Integer.valueOf(lightLevel)), 3);
            activeFlashes.computeIfAbsent(level, l -> new HashMap()).put(targetPos, System.currentTimeMillis());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static BlockPos findValidPosition(ServerLevel level, BlockPos pos) {
        if (level.m_8055_(pos).m_60795_()) {
            return pos;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos nearby = pos.m_7918_(dx, dy, dz);
                    if (!level.m_8055_(nearby).m_60795_()) continue;
                    return nearby;
                }
            }
        }
        return null;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<ServerLevel, Map<BlockPos, Long>>> it = activeFlashes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ServerLevel, Map<BlockPos, Long>> levelEntry = it.next();
            Map<BlockPos, Long> map = levelEntry.getValue();
            ServerLevel level = levelEntry.getKey();
            map.entrySet().removeIf(entry -> {
                if (now - (Long)entry.getValue() >= 10L) {
                    if (level.m_8055_((BlockPos)entry.getKey()).m_60734_() == Blocks.f_152480_) {
                        level.m_7731_((BlockPos)entry.getKey(), Blocks.f_50016_.m_49966_(), 3);
                    }
                    return true;
                }
                return false;
            });
            if (!map.isEmpty()) continue;
            it.remove();
        }
    }
}

