/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges;

import com.radar.biohazardchanges.Config;
import com.radar.biohazardchanges.common.events.ServerEventRegistry;
import com.radar.biohazardchanges.common.network.NetworkHandler;
import com.radar.biohazardchanges.common.registry.ModBlockEntities;
import com.radar.biohazardchanges.common.registry.ModBlocks;
import com.radar.biohazardchanges.common.registry.ModItems;
import com.radar.biohazardchanges.common.registry.ModSounds;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="biohazardchanges")
public class Biohazardchanges {
    public static final String MODID = "biohazardchanges";
    public static Logger LOGGER = LogManager.getLogger((String)"biohazardchanges");

    public Biohazardchanges() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModSounds.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    public void setup(FMLCommonSetupEvent event) {
        NetworkHandler.register();
        ServerEventRegistry.registerEvents();
        event.enqueueWork(() -> {
            block3: {
                try {
                    Field interactionsField = FluidInteractionRegistry.class.getDeclaredField("INTERACTIONS");
                    interactionsField.setAccessible(true);
                    Map interactions = (Map)interactionsField.get(null);
                    List lavaInteractions = (List)interactions.get(ForgeMod.LAVA_TYPE.get());
                    if (lavaInteractions == null) break block3;
                    Iterator iterator = lavaInteractions.iterator();
                    while (iterator.hasNext()) {
                        FluidInteractionRegistry.InteractionInformation interaction = (FluidInteractionRegistry.InteractionInformation)iterator.next();
                        if (lavaInteractions.size() != 2 || lavaInteractions.indexOf(interaction) != 1) continue;
                        iterator.remove();
                        LOGGER.info("Removed basalt interaction (by position in list)");
                        break;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to remove basalt interaction: {}", (Object)e.getMessage());
                    e.printStackTrace();
                }
            }
        });
    }

    @Mod.EventBusSubscriber(modid="biohazardchanges")
    public static class ServerEvents {
        @SubscribeEvent
        public static void onRegisterCommands(RegisterCommandsEvent event) {
        }
    }
}

