/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.card;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.radar.biohazardchanges.client.card.CardElement;
import com.radar.biohazardchanges.client.card.CardSide;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class PlayerFaceElement
implements CardElement {
    private final CardSide side;
    private final ResourceLocation skinTexture;
    private final int x;
    private final int y;
    private final int z;
    private final int size;

    public PlayerFaceElement(CardSide side, ResourceLocation skinTexture, int x, int y, int z, int size) {
        this.side = side;
        this.skinTexture = skinTexture;
        this.x = x;
        this.y = y;
        this.z = z;
        this.size = size;
    }

    @Override
    public CardSide getSide() {
        return this.side;
    }

    @Override
    public void render3D(PoseStack poseStack, int cardWidth, int cardHeight) {
        poseStack.m_85836_();
        poseStack.m_252880_((float)(-cardWidth) / 2.0f, (float)(-cardHeight) / 2.0f, 0.0f);
        poseStack.m_252880_((float)this.x, (float)this.y, (float)this.z);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.skinTexture);
        float u0 = 0.125f;
        float v0 = 0.125f;
        float u1 = 0.25f;
        float v1 = 0.25f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, 0.0f, (float)this.size, 0.0f).m_7421_(u0, v1).m_5752_();
        buffer.m_252986_(matrix, (float)this.size, (float)this.size, 0.0f).m_7421_(u1, v1).m_5752_();
        buffer.m_252986_(matrix, (float)this.size, 0.0f, 0.0f).m_7421_(u1, v0).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(u0, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        poseStack.m_85849_();
    }
}

