/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.events;

import com.radar.biohazardchanges.Config;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biohazardchanges", value={Dist.CLIENT})
public class ClientEvents {
    private static final String[] VANILLA_MUSIC_SOUNDS = new String[]{"music.game", "music.creative", "music.end", "music.under_water", "music.menu", "music.credits", "music.nether"};

    @SubscribeEvent
    public static void onPlaySound(PlaySoundEvent event) {
        if (!((Boolean)Config.ENABLED.get()).booleanValue() || !((Boolean)Config.CUSTOM_MUSIC_ENABLED.get()).booleanValue()) {
            return;
        }
        SoundInstance sound = event.getSound();
        String soundPath = sound.m_7904_().toString();
        if (sound.m_8070_() == SoundSource.MUSIC) {
            System.out.println("Music sound playing: " + soundPath);
        }
        if (sound.m_8070_() == SoundSource.MUSIC && ClientEvents.isVanillaMusic(soundPath) && !soundPath.contains("biohazardchanges:")) {
            System.out.println("Canceling vanilla music: " + soundPath);
            event.setCanceled(true);
        }
    }

    private static boolean isVanillaMusic(String soundPath) {
        for (String vanillaMusic : VANILLA_MUSIC_SOUNDS) {
            if (!soundPath.startsWith(vanillaMusic)) continue;
            return true;
        }
        return false;
    }
}

