/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.music;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;

public class FadingSound
extends AbstractTickableSoundInstance {
    public static final int NO_FADE = 0;
    public static final int SHORT_FADE = 10;
    public static final int MEDIUM_FADE = 40;
    public static final int LONG_FADE = 100;
    private float targetVolume;
    private float startVolume;
    private int fadeTicks;
    private int fadeTimer;
    private Mode mode = Mode.NONE;
    private boolean removeOnFadeOut;

    public FadingSound(SoundEvent soundEvent, int fadeIn, float volume) {
        super(soundEvent, SoundSource.MUSIC, RandomSource.m_216327_());
        this.f_119578_ = true;
        this.f_119582_ = true;
        this.f_119580_ = SoundInstance.Attenuation.NONE;
        this.targetVolume = volume;
        if (fadeIn > 0) {
            this.f_119573_ = 0.0f;
            this.mode = Mode.FADE_IN;
            this.fadeTicks = fadeIn;
        } else {
            this.f_119573_ = volume;
        }
    }

    public FadingSound(SoundEvent soundEvent, int fadeIn) {
        this(soundEvent, fadeIn, 1.0f);
    }

    public void m_7788_() {
        if (this.mode == Mode.NONE) {
            return;
        }
        ++this.fadeTimer;
        float progress = (float)this.fadeTimer / (float)this.fadeTicks;
        switch (this.mode) {
            case FADE_IN: {
                if (progress >= 1.0f) {
                    this.f_119573_ = this.targetVolume;
                    this.mode = Mode.NONE;
                    break;
                }
                this.f_119573_ = this.startVolume + progress * (this.targetVolume - this.startVolume);
                break;
            }
            case FADE_OUT: {
                if (progress >= 1.0f) {
                    this.f_119573_ = 0.0f;
                    this.mode = Mode.NONE;
                    if (!this.removeOnFadeOut) break;
                    this.m_119609_();
                    break;
                }
                this.f_119573_ = this.startVolume * (1.0f - progress);
            }
        }
    }

    public void fadeOut(int ticks, boolean remove) {
        if (ticks <= 0) {
            this.f_119573_ = 0.0f;
            this.m_119609_();
            return;
        }
        this.startVolume = this.f_119573_;
        this.mode = Mode.FADE_OUT;
        this.fadeTicks = ticks;
        this.fadeTimer = 0;
        this.removeOnFadeOut = remove;
    }

    public void changeVolume(float newVol, int ticks) {
        if (ticks <= 0) {
            this.f_119573_ = newVol;
            this.targetVolume = newVol;
            this.mode = Mode.NONE;
            return;
        }
        this.startVolume = this.f_119573_;
        this.targetVolume = newVol;
        this.fadeTicks = ticks;
        this.fadeTimer = 0;
        this.mode = newVol > this.startVolume ? Mode.FADE_IN : Mode.FADE_OUT;
        this.removeOnFadeOut = false;
    }

    private static enum Mode {
        NONE,
        FADE_IN,
        FADE_OUT;

    }
}

