/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.radar.biohazardchanges.client.card.CardData;
import com.radar.biohazardchanges.client.card.CardElement;
import com.radar.biohazardchanges.client.card.CardInfoPanelText;
import com.radar.biohazardchanges.client.card.CardSide;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class CardScreenBase
extends Screen {
    protected static final float FLIP_SPEED = 0.1f;
    protected final CardData cardData;
    protected final List<CardInfoPanelText> infoPanels = new ArrayList<CardInfoPanelText>();
    protected boolean isFlipping = false;
    protected boolean isFlipped = false;
    protected float flipProgress = 0.0f;
    protected float rotationX = 0.0f;
    protected float rotationY = 0.0f;
    protected float rotationZ = 0.0f;
    protected int CARD_WIDTH;
    protected int CARD_HEIGHT;

    public CardScreenBase(Component title, CardData cardData, int cardWidth, int cardHeight) {
        super(title);
        this.f_96541_ = Minecraft.m_91087_();
        this.cardData = cardData;
        this.CARD_WIDTH = cardWidth;
        this.CARD_HEIGHT = cardHeight;
    }

    public void addInfoPanel(Component text, int x, int y, int color, boolean dropShadow, int wrapWidth, float lineSpacing) {
        this.infoPanels.add(new CardInfoPanelText(text, x, y, color, dropShadow, wrapWidth, lineSpacing));
    }

    public void addInfoPanelWithBackground(Component text, int x, int y, int color, boolean dropShadow, int wrapWidth, float lineSpacing, int backgroundColor, int padding) {
        this.infoPanels.add(new CardInfoPanelText(text, x, y, color, dropShadow, wrapWidth, lineSpacing, backgroundColor, true, padding));
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        this.renderVignette(gui);
        this.handleFlipAnimation();
        float normalizedY = (this.rotationY % 360.0f + 360.0f) % 360.0f;
        boolean actuallyFlipped = normalizedY > 90.0f && normalizedY < 270.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)centerX, (float)centerY, 200.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(this.rotationX));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.rotationY));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(this.rotationZ));
        ResourceLocation frontTexture = this.cardData.frontTexture() != null ? this.cardData.frontTexture() : this.cardData.bothTexture();
        this.drawCardFace(poseStack, frontTexture, this.CARD_WIDTH, this.CARD_HEIGHT, false);
        for (CardElement element : this.cardData.elements()) {
            if (element.getSide() != CardSide.FRONT && element.getSide() != CardSide.BOTH) continue;
            element.render3D(poseStack, this.CARD_WIDTH, this.CARD_HEIGHT);
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        ResourceLocation backTexture = this.cardData.backTexture() != null ? this.cardData.backTexture() : this.cardData.bothTexture();
        this.drawCardFace(poseStack, backTexture, this.CARD_WIDTH, this.CARD_HEIGHT, true);
        for (CardElement element : this.cardData.elements()) {
            if (element.getSide() != CardSide.BACK && element.getSide() != CardSide.BOTH) continue;
            element.render3D(poseStack, this.CARD_WIDTH, this.CARD_HEIGHT);
        }
        poseStack.m_85849_();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        for (CardInfoPanelText panel : this.infoPanels) {
            panel.render(gui);
        }
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
    }

    protected void drawCardFace(PoseStack poseStack, ResourceLocation texture, int width, int height, boolean reversed) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float halfW = (float)width / 2.0f;
        float halfH = (float)height / 2.0f;
        if (!reversed) {
            bufferBuilder.m_252986_(matrix, -halfW, halfH, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix, halfW, halfH, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix, halfW, -halfH, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrix, -halfW, -halfH, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        } else {
            bufferBuilder.m_252986_(matrix, -halfW, halfH, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix, halfW, halfH, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix, halfW, -halfH, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrix, -halfW, -halfH, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    protected void renderVignette(GuiGraphics gui) {
        PoseStack poseStack = gui.m_280168_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.disableDepthTest();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float alpha = 0.5f;
        bufferBuilder.m_252986_(matrix, 0.0f, (float)this.f_96544_, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)this.f_96543_, (float)this.f_96544_, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)this.f_96543_, 0.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    protected void handleFlipAnimation() {
        if (this.isFlipping) {
            this.flipProgress += 0.1f;
            if (this.flipProgress >= 1.0f) {
                this.flipProgress = 0.0f;
                this.isFlipping = false;
                this.isFlipped = !this.isFlipped;
            }
        }
        this.rotationY = this.isFlipped ? 180.0f - this.flipProgress * 180.0f : this.flipProgress * 180.0f;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            if (!this.isFlipping) {
                this.isFlipping = true;
                this.flipProgress = 0.0f;
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.rotationX += (float)dragY * 0.5f;
        this.rotationZ += (float)dragX * 0.5f;
        return true;
    }

    public boolean m_7043_() {
        return false;
    }
}

