/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.vfx;

import com.radar.biohazardchanges.client.vfx.VFXTimelineRegistry;
import com.radar.biohazardchanges.client.vfx.base.EffectTimeline;
import com.radar.biohazardchanges.client.vfx.base.clips.EventClip;
import com.radar.biohazardchanges.client.vfx.base.clips.FloatClip;
import com.radar.biohazardchanges.client.vfx.base.clips.ParticleClip;
import com.radar.biohazardchanges.client.vfx.base.clips.SoundClip;
import com.radar.biohazardchanges.client.vfx.base.tracks.EventTrack;
import com.radar.biohazardchanges.client.vfx.base.tracks.FloatTrack;
import com.radar.biohazardchanges.client.vfx.base.tracks.ParticleTrack;
import com.radar.biohazardchanges.client.vfx.base.tracks.SoundTrack;
import com.radar.biohazardchanges.client.vfx.particles.IParticleScript;
import com.radar.biohazardchanges.client.vfx.particles.IParticleSupplier;
import com.radar.biohazardchanges.client.vfx.playback.VFXSystem;
import com.radar.biohazardchanges.common.registry.ModSounds;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;

public class BiohazardVFX {
    public static final IParticleSupplier SPARKS = (level, random, pos) -> ParticleTypes.f_123815_;
    public static final IParticleSupplier MAGIC = (level, random, pos) -> ParticleTypes.f_123771_;
    public static final IParticleScript SPARKLE_BURST = (instance, builder) -> {
        RandomSource random = instance.getLevel().f_46441_;
        float initialSpeed = 0.1f + random.m_188501_() * 0.2f;
        builder.setLifetime(15 + random.m_188503_(10)).setGravityStrength(0.0f).addMotion((double)initialSpeed, 0.0, 0.0).setFrictionStrength(0.9f).setScaleData(GenericParticleData.create((float)0.4f, (float)0.0f).setEasing(Easing.SINE_OUT).build());
    };
    public static final IParticleScript MAGIC_PLUME = (instance, builder) -> {
        RandomSource random = instance.getLevel().f_46441_;
        float initialSpeed = 0.02f + random.m_188501_() * 0.05f;
        builder.setLifetime(30 + random.m_188503_(20)).setGravityStrength(0.01f).addMotion(0.0, (double)initialSpeed, 0.0).setFrictionStrength(0.98f);
    };
    private static final int[] BLACK = new int[]{0x1D1D1D};
    private static final int[] DARK_PURPLE = new int[]{3874650};
    private static final int[] MEDIUM_PURPLE = new int[]{6044554};
    private static final int[] LIGHT_PURPLE = new int[]{8545965};
    private static final int[] LAVENDER = new int[]{12890585};
    public static final EffectTimeline BIRTHDAY_CELEBRATION = VFXTimelineRegistry.register(BiohazardVFX.createBirthdayTimeline());
    public static final EffectTimeline SOUND_SYNC_FINALE = VFXTimelineRegistry.register(BiohazardVFX.createSoundSyncFinale());

    private static EffectTimeline createBirthdayTimeline() {
        FloatTrack floatTrack = new FloatTrack();
        EventTrack eventTrack = new EventTrack();
        ParticleTrack particleTrack = new ParticleTrack();
        floatTrack.addClip(new FloatClip(0, 20, "jitter_magnitude", 0.0f, 0.075f, Easing.CUBIC_IN));
        floatTrack.addClip(new FloatClip(20, 80, "jitter_magnitude", 0.075f, 0.075f, Easing.SINE_OUT));
        particleTrack.addClip(new ParticleClip(0, 80, SPARKS, SPARKLE_BURST, 2));
        particleTrack.addClip(new ParticleClip(20, 80, MAGIC, MAGIC_PLUME, 4));
        eventTrack.addClip(new EventClip(100, 0){
            {
                this.onStart = instance -> VFXSystem.play(SOUND_SYNC_FINALE, instance.getLevel(), instance.getPosition().m_82520_(-20.0, 0.0, 0.0));
            }
        });
        return EffectTimeline.builder(new ResourceLocation("biohazardchanges", "birthday_celebration"), 200).addTrack(floatTrack).addTrack(particleTrack).addTrack(eventTrack).build();
    }

    private static CompoundTag createFireworkNBT(int flight, String shape, int[] colors, int[] fadeColors, boolean trail, boolean twinkle) {
        CompoundTag fireworkData = new CompoundTag();
        fireworkData.m_128344_("Flight", (byte)flight);
        fireworkData.m_128359_("Shape", shape);
        if (colors != null) {
            fireworkData.m_128385_("Colors", colors);
        }
        if (fadeColors != null) {
            fireworkData.m_128385_("FadeColors", fadeColors);
        }
        fireworkData.m_128379_("HasTrail", trail);
        fireworkData.m_128379_("HasTwinkle", twinkle);
        return fireworkData;
    }

    private static void addOffset(CompoundTag nbt, Vec3 offset) {
        ListTag offsetTag = new ListTag();
        offsetTag.add((Object)DoubleTag.m_128500_((double)offset.f_82479_));
        offsetTag.add((Object)DoubleTag.m_128500_((double)offset.f_82480_));
        offsetTag.add((Object)DoubleTag.m_128500_((double)offset.f_82481_));
        nbt.m_128365_("Offset", (Tag)offsetTag);
    }

    private static int getLaunchTime(double explosionTimeInSeconds, int flightDuration) {
        double avgLifetimeInSeconds = ((double)(10 * flightDuration) + 5.5) / 20.0;
        return (int)Math.max(0.0, (explosionTimeInSeconds - avgLifetimeInSeconds) * 20.0);
    }

    private static EffectTimeline createSoundSyncFinale() {
        EventTrack eventTrack = new EventTrack();
        SoundTrack soundTrack = new SoundTrack();
        soundTrack.addClip(new SoundClip(0, 0, (SoundEvent)ModSounds.FINALE_START.get(), 1.0f, 1.0f));
        int flight = 2;
        double[] explosionTimes = new double[]{6.0, 8.3, 10.5, 11.25, 12.0, 15.0, 17.0, 20.0, 21.0, 22.0};
        String[] shapes = new String[]{"small_ball", "star", "burst", "creeper", "large_ball", "star", "burst", "creeper", "large_ball", "star"};
        int[][] colors = new int[][]{LAVENDER, LIGHT_PURPLE, MEDIUM_PURPLE, DARK_PURPLE, LAVENDER, LIGHT_PURPLE, MEDIUM_PURPLE, DARK_PURPLE, LAVENDER, LIGHT_PURPLE};
        for (int i = 0; i < explosionTimes.length; ++i) {
            int launchTime = BiohazardVFX.getLaunchTime(explosionTimes[i], flight);
            CompoundTag nbt = BiohazardVFX.createFireworkNBT(flight, shapes[i], colors[i], BLACK, true, true);
            BiohazardVFX.addOffset(nbt, new Vec3(0.0, 0.0, 0.0));
            EventClip clip = new EventClip(launchTime, 0);
            clip.setServerEventId(new ResourceLocation("biohazardchanges", "spawn_firework"));
            clip.setExtraData(nbt);
            eventTrack.addClip(clip);
        }
        int spamStartTime = 480;
        for (int i = 0; i < 40; ++i) {
            String shape;
            int launchTime = BiohazardVFX.getLaunchTime(24.0 + (double)i * 0.1, 1);
            String string = shape = i % 2 == 0 ? "star" : "creeper";
            int[] color = i % 3 == 0 ? LAVENDER : (i % 3 == 1 ? MEDIUM_PURPLE : DARK_PURPLE);
            CompoundTag nbt = BiohazardVFX.createFireworkNBT(1, shape, color, BLACK, true, i % 2 == 0);
            BiohazardVFX.addOffset(nbt, new Vec3(0.0, 5.0, 0.0));
            EventClip clip = new EventClip(launchTime, 0);
            clip.setServerEventId(new ResourceLocation("biohazardchanges", "spawn_firework"));
            clip.setExtraData(nbt);
            eventTrack.addClip(clip);
        }
        return EffectTimeline.builder(new ResourceLocation("biohazardchanges", "sound_sync_finale"), 600).addTrack(eventTrack).addTrack(soundTrack).build();
    }

    public static void register() {
    }
}

